/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.DexFileReader;
import com.android.tools.r8.dex.Segment;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;

public class DexSegments {
    public static void main(String[] args) throws IOException, ProguardRuleParserException, CompilationException, ExecutionException {
        Command.Builder builder = Command.parse(args);
        Command command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        AndroidApp app = command.getInputApp();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (Closer closer = Closer.create();){
            for (Resource resource : app.getDexProgramResources()) {
                for (Segment segment : DexFileReader.parseMapFrom(resource.getStream(closer))) {
                    int value2 = result.computeIfAbsent(segment.typeName(), key -> 0);
                    result.put(segment.typeName(), value2 + segment.size());
                }
            }
        }
        System.out.println("Segments in dex application (name: size):");
        result.forEach((key, value) -> System.out.println(" - " + key + ": " + value));
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: dexsegments [options] <input-files>", (Object)" where <input-files> are dex files", (Object)"  --version               # Print the version of r8.", (Object)"  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) throws CompilationException, IOException {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    throw new CompilationException("Unknown option: " + arg);
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, CompilationMode mode, int minApiLevel) {
            super(inputApp, outputPath, outputMode, mode, minApiLevel);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            private Builder() {
                super(CompilationMode.RELEASE);
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public Command build() throws CompilationException, IOException {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                this.validate();
                return new Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), this.getMode(), this.getMinApiLevel());
            }
        }
    }
}

