/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.naming.MinifiedNameMapPrinter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.PackageDistribution;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ApplicationWriter {
    public final DexApplication application;
    public final AppInfo appInfo;
    public final NamingLens namingLens;
    public final byte[] proguardSeedsData;
    public final InternalOptions options;

    public ApplicationWriter(DexApplication application, AppInfo appInfo, InternalOptions options, NamingLens namingLens, byte[] proguardSeedsData) {
        assert (application != null);
        this.application = application;
        this.appInfo = appInfo;
        assert (options != null);
        this.options = options;
        this.namingLens = namingLens;
        this.proguardSeedsData = proguardSeedsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidApp write(PackageDistribution packageDistribution, ExecutorService executorService) throws IOException, ExecutionException {
        this.application.timing.begin("DexApplication.write");
        try {
            byte[] byArray;
            this.application.dexItemFactory.sort(this.namingLens);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            VirtualFile.Distributor distributor = null;
            if (this.options.outputMode == OutputMode.FilePerClass) {
                assert (packageDistribution == null) : "Cannot combine package distribution definition with file-per-class option.";
                distributor = new VirtualFile.FilePerClassDistributor(this);
            } else if (this.options.minApiLevel < 21 && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty()) {
                if (packageDistribution != null) {
                    throw new CompilationError("Cannot apply package distribution. Multidex is not supported with API level " + this.options.minApiLevel + ". For API level < " + 21 + ", main dex classes list or rules must be specified.");
                }
                distributor = new VirtualFile.MonoDexDistributor(this);
            } else if (packageDistribution != null) {
                assert (!this.options.minimalMainDex) : "Cannot combine package distribution definition with minimal-main-dex option.";
                distributor = new VirtualFile.PackageMapDistributor(this, packageDistribution, executorService);
            } else {
                distributor = new VirtualFile.FillFilesDistributor(this, this.options.minimalMainDex);
            }
            Map<Integer, VirtualFile> newFiles = ((VirtualFile.Distributor)distributor).run();
            LinkedHashMap<Object, Future<byte[]>> dexDataFutures = new LinkedHashMap<Object, Future<byte[]>>();
            for (int i = 0; i < newFiles.size(); ++i) {
                VirtualFile newFile = newFiles.get(i);
                assert (newFile.getId() == i);
                if (newFile.isEmpty()) continue;
                dexDataFutures.put(newFile, executorService.submit(() -> this.writeDexFile(newFile)));
            }
            AndroidApp.Builder builder = AndroidApp.builder();
            try {
                for (Map.Entry entry : dexDataFutures.entrySet()) {
                    builder.addDexProgramData((byte[])((Future)entry.getValue()).get(), ((VirtualFile)entry.getKey()).getClassDescriptors());
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for future.", e);
            }
            byte[] proguardMapResult = this.writeProguardMapFile();
            if (proguardMapResult != null) {
                builder.setProguardMapData(proguardMapResult);
            }
            if (this.proguardSeedsData != null) {
                builder.setProguardSeedsData(this.proguardSeedsData);
            }
            if ((byArray = this.writeMainDexList()) != null) {
                builder.setMainDexListData(byArray);
            }
            AndroidApp androidApp = builder.build();
            return androidApp;
        }
        finally {
            this.application.timing.end();
        }
    }

    private byte[] writeDexFile(VirtualFile vfile) {
        FileWriter fileWriter = new FileWriter(vfile.computeMapping(this.application), this.application, this.appInfo, this.options, this.namingLens);
        fileWriter.rewriteCodeWithJumboStrings(vfile.classes());
        fileWriter.collect();
        return fileWriter.generate();
    }

    private byte[] writeProguardMapFile() throws IOException {
        if (!this.namingLens.isIdentityLens()) {
            MinifiedNameMapPrinter printer = new MinifiedNameMapPrinter(this.application, this.namingLens);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(bytes);
            printer.write(stream);
            stream.flush();
            return bytes.toByteArray();
        }
        if (this.application.getProguardMap() != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes);
            this.application.getProguardMap().write(writer, !this.options.skipDebugLineNumberOpt);
            ((Writer)writer).flush();
            return bytes.toByteArray();
        }
        return null;
    }

    private String mapMainDexListName(DexType type) {
        return DescriptorUtils.descriptorToJavaType(this.namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private byte[] writeMainDexList() throws IOException {
        if (this.application.mainDexList.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes);
        this.application.mainDexList.forEach(type -> writer.println(this.mapMainDexListName((DexType)type)));
        writer.flush();
        return bytes.toByteArray();
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(DexAnnotationSetRefList annotationSetRefList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

