/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Phi
extends Value {
    private final BasicBlock block;
    private final List<Value> operands = new ArrayList<Value>();
    private List<Map<Integer, Value>> definitionUsers = new ArrayList<Map<Integer, Value>>();
    private MoveType outType = null;

    public Phi(int number, BasicBlock block, MoveType type, DebugLocalInfo local) {
        super(number, type, local == null ? null : new Value.DebugInfo(local, null));
        this.block = block;
        block.addPhi(this);
    }

    @Override
    public boolean isPhi() {
        return true;
    }

    @Override
    public Phi asPhi() {
        return this;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    public void addOperands(IRBuilder builder, int register) {
        assert (this.operands.isEmpty());
        boolean canBeNull = false;
        if (this.block.getPredecessors().size() == 0) {
            this.throwUndefinedValueError();
        }
        for (BasicBlock pred : this.block.getPredecessors()) {
            BasicBlock.EdgeType edgeType = pred.getEdgeType(this.block);
            Value operand = builder.readRegister(register, pred, edgeType, this.type, this.getLocalInfo());
            canBeNull |= operand.canBeNull();
            this.appendOperand(operand);
        }
        if (!canBeNull) {
            this.markNeverNull();
        }
        this.removeTrivialPhi();
    }

    public void addOperands(List<Value> operands) {
        assert (this.operands.isEmpty());
        boolean canBeNull = false;
        if (operands.size() == 0) {
            this.throwUndefinedValueError();
        }
        for (Value operand : operands) {
            canBeNull |= operand.canBeNull();
            this.appendOperand(operand);
        }
        if (!canBeNull) {
            this.markNeverNull();
        }
        this.removeTrivialPhi();
    }

    private void throwUndefinedValueError() {
        throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not define on all control-flow paths leading to the use.");
    }

    private void appendOperand(Value operand) {
        this.operands.add(operand);
        operand.addPhiUser(this);
    }

    public Value getOperand(int predIndex) {
        return this.operands.get(predIndex);
    }

    public List<Value> getOperands() {
        return this.operands;
    }

    public void removeOperand(int index) {
        this.operands.get(index).removePhiUser(this);
        this.operands.remove(index);
    }

    public void removeOperandsByIndex(List<Integer> operandsToRemove) {
        if (operandsToRemove.isEmpty()) {
            return;
        }
        ArrayList<Value> copy = new ArrayList<Value>(this.operands);
        this.operands.clear();
        int current = 0;
        for (int i : operandsToRemove) {
            this.operands.addAll(copy.subList(current, i));
            ((Value)copy.get(i)).removePhiUser(this);
            current = i + 1;
        }
        this.operands.addAll(copy.subList(current, copy.size()));
    }

    public void replace(int predIndex, Value newValue) {
        Value current = this.operands.get(predIndex);
        this.operands.set(predIndex, newValue);
        newValue.addPhiUser(this);
        current.removePhiUser(this);
    }

    private void replaceTrivialPhi(Value current, Value newValue) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (this.operands.get(i) != current) continue;
            this.operands.set(i, newValue);
            newValue.addPhiUser(this);
        }
    }

    public boolean isTrivialPhi() {
        Value same = null;
        for (Value op : this.operands) {
            if (op == same || op == this) continue;
            if (same != null) {
                return false;
            }
            same = op;
        }
        return true;
    }

    public void removeTrivialPhi() {
        Value same = null;
        for (Value value : this.operands) {
            if (value == same || value == this) continue;
            if (same != null) {
                assert (!this.isTrivialPhi());
                return;
            }
            same = value;
        }
        assert (this.isTrivialPhi());
        for (Value value : this.operands) {
            value.removePhiUser(this);
        }
        for (Instruction instruction : this.uniqueUsers()) {
            instruction.replaceValue(this, same);
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.replaceTrivialPhi(this, same);
        }
        if (this.debugUsers() != null) {
            for (Instruction instruction : this.debugUsers()) {
                instruction.replaceDebugPhi(this, same);
            }
        }
        if (this.definitionUsers != null) {
            for (Map map : this.definitionUsers) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != this) continue;
                    entry.setValue(same);
                    if (!same.isPhi()) continue;
                    same.asPhi().addDefinitionsUser(map);
                }
            }
        }
        for (Phi phi : this.uniquePhiUsers()) {
            phi.removeTrivialPhi();
        }
        this.block.removePhi(this);
    }

    public String printPhi() {
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        builder.append(" <- phi");
        StringUtils.append(builder, ListUtils.map(this.operands, operand -> "v" + operand.number));
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        int uses = this.numberOfPhiUsers() + this.numberOfUsers();
        printer.print("0 ").append(uses).append(" v").append(this.number).append(" Phi");
        for (Value operand : this.operands) {
            printer.append(" v").append(operand.number);
        }
    }

    public void addDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.add(currentDefinitions);
    }

    public void removeDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.remove(currentDefinitions);
    }

    public void clearDefinitionsUsers() {
        this.definitionUsers = null;
    }

    private boolean isSingleConstZero(Value value) {
        return value.definition != null && value.definition.isConstNumber() && value.definition.asConstNumber().isZero() && value.outType() == MoveType.SINGLE;
    }

    private MoveType computeOutType(Set<Phi> active) {
        if (this.outType != null) {
            return this.outType;
        }
        active.add(this);
        for (Value operand : this.operands) {
            if (operand.isPhi() || this.isSingleConstZero(operand)) continue;
            return operand.outType();
        }
        for (Value operand : this.operands) {
            MoveType phiType;
            if (!operand.isPhi() || active.contains(operand) || (phiType = operand.asPhi().computeOutType(active)) == MoveType.SINGLE) continue;
            return phiType;
        }
        assert (this.type == MoveType.SINGLE || this.type == MoveType.OBJECT);
        return MoveType.SINGLE;
    }

    @Override
    public MoveType outType() {
        if (this.outType != null) {
            return this.outType;
        }
        return this.computeOutType(new HashSet<Phi>());
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean needsRegister() {
        return true;
    }
}

