/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassNameMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final RootSetBuilder.RootSet rootSet;
    private final String packagePrefix;
    private final Set<DexString> usedTypeNames = Sets.newIdentityHashSet();
    private final Map<DexType, DexString> renaming = Maps.newIdentityHashMap();
    private final Map<String, NamingState> states = new HashMap<String, NamingState>();
    private final List<String> dictionary;
    private final boolean keepInnerClassStructure;

    public ClassNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, RootSetBuilder.RootSet rootSet, String packagePrefix, List<String> dictionary, boolean keepInnerClassStructure) {
        this.appInfo = appInfo;
        this.rootSet = rootSet;
        this.packagePrefix = packagePrefix;
        this.dictionary = dictionary;
        this.keepInnerClassStructure = keepInnerClassStructure;
    }

    public Map<DexType, DexString> computeRenaming() {
        Iterable<DexProgramClass> classes = this.appInfo.classes();
        for (DexClass dexClass : this.appInfo.classes()) {
            if (!this.rootSet.noObfuscation.contains(dexClass)) continue;
            assert (!this.renaming.containsKey(dexClass.type));
            this.registerClassAsUsed(dexClass.type);
        }
        for (DexClass dexClass : this.appInfo.classes()) {
            if (this.renaming.containsKey(dexClass.type)) continue;
            DexString renamed = this.computeName(dexClass);
            this.renaming.put(dexClass.type, renamed);
        }
        this.appInfo.dexItemFactory.forAllTypes(this::renameArrayTypeIfNeeded);
        return Collections.unmodifiableMap(this.renaming);
    }

    private void registerClassAsUsed(DexType type) {
        DexType outerClass;
        this.renaming.put(type, type.descriptor);
        this.usedTypeNames.add(type.descriptor);
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null && !this.renaming.containsKey(outerClass)) {
            this.registerClassAsUsed(outerClass);
        }
    }

    private DexType getOutClassForType(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        DexAnnotation annotation = clazz.annotations.getFirstMatching(this.appInfo.dexItemFactory.annotationEnclosingClass);
        if (annotation != null) {
            assert (annotation.annotation.elements.length == 1);
            DexValue value = annotation.annotation.elements[0].value;
            return (DexType)((DexValue.DexValueType)value).value;
        }
        return null;
    }

    private DexString computeName(DexClass clazz) {
        DexType outerClass;
        NamingState state = null;
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(clazz.type)) != null) {
            state = this.getStateForOuterClass(outerClass);
        }
        if (state == null) {
            String packageName = this.getPackageNameFor(clazz);
            state = this.getStateFor(packageName);
        }
        return state.nextTypeName();
    }

    private String getPackageNameFor(DexClass clazz) {
        if (this.packagePrefix == null || this.rootSet.keepPackageName.contains(clazz)) {
            return clazz.type.getPackageDescriptor();
        }
        return this.packagePrefix;
    }

    private NamingState getStateFor(String packageName) {
        return this.states.computeIfAbsent(packageName, x$0 -> new NamingState((String)x$0));
    }

    private NamingState getStateForOuterClass(DexType outer) {
        String prefix = DescriptorUtils.getClassBinaryNameFromDescriptor(outer.toDescriptorString());
        return this.states.computeIfAbsent(prefix, k -> {
            DexString renamed = this.renaming.get(outer);
            if (renamed == null) {
                DexClass outerClass = this.appInfo.definitionFor(outer);
                if (outerClass == null) {
                    renamed = outer.descriptor;
                } else {
                    renamed = this.computeName(outerClass);
                    this.renaming.put(outer, renamed);
                }
            }
            String binaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamed.toString());
            return new NamingState(binaryName, "$");
        });
    }

    private void renameArrayTypeIfNeeded(DexType type) {
        DexType base;
        DexString value;
        if (type.isArrayType() && (value = this.renaming.get(base = type.toBaseType(this.appInfo.dexItemFactory))) != null) {
            int dimensions = type.descriptor.numberOfLeadingSquareBrackets();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                builder.append('[');
            }
            builder.append(value.toString());
            DexString descriptor = this.appInfo.dexItemFactory.createString(builder.toString());
            this.renaming.put(type, descriptor);
        }
    }

    private class NamingState {
        private final char[] packagePrefix;
        private final String separator;
        private int typeCounter = 1;
        private Iterator<String> dictionaryIterator;

        NamingState(String packageName) {
            this(packageName, "/");
        }

        NamingState(String packageName, String separator) {
            this.packagePrefix = ("L" + packageName + (packageName.isEmpty() ? "" : separator)).toCharArray();
            this.separator = separator;
            this.dictionaryIterator = ClassNameMinifier.this.dictionary.iterator();
        }

        public char[] getPackagePrefix() {
            return this.packagePrefix;
        }

        protected String nextSuggestedName() {
            StringBuilder nextName = new StringBuilder();
            if (this.dictionaryIterator.hasNext()) {
                nextName.append(this.getPackagePrefix()).append(this.dictionaryIterator.next()).append(';');
                return nextName.toString();
            }
            return StringUtils.numberToIdentifier(this.packagePrefix, this.typeCounter++, true);
        }

        private DexString nextTypeName() {
            DexString candidate;
            do {
                candidate = ((ClassNameMinifier)ClassNameMinifier.this).appInfo.dexItemFactory.createString(this.nextSuggestedName());
            } while (ClassNameMinifier.this.usedTypeNames.contains(candidate));
            return candidate;
        }
    }
}

