/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TreePruner {
    private DexApplication application;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions options;

    public TreePruner(DexApplication application, Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.application = application;
        this.appInfo = appInfo;
        this.options = options;
    }

    public DexApplication run() {
        DexApplication result;
        this.application.timing.begin("Pruning application...");
        if (this.options.debugKeepRules && !this.options.skipMinification) {
            System.out.println("NOTE: Debugging keep rules on a minified build might yield broken builds, as\n      minifcation also depends on the used keep rules. We recommend using\n      --skip-minification.");
        }
        try {
            result = this.removeUnused(this.application).build();
        }
        finally {
            this.application.timing.end();
        }
        return result;
    }

    private DexApplication.Builder removeUnused(DexApplication application) {
        return new DexApplication.Builder(application).replaceProgramClasses(this.getNewProgramClasses(application.classes()));
    }

    private List<DexProgramClass> getNewProgramClasses(List<DexProgramClass> classes) {
        ArrayList<DexProgramClass> newClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : classes) {
            if (!this.appInfo.liveTypes.contains(clazz.type)) continue;
            newClasses.add(clazz);
            if (!(this.appInfo.instantiatedTypes.contains(clazz.type) || this.options.debugKeepRules && this.hasDefaultConstructor(clazz))) {
                if (clazz.accessFlags.isFinal()) {
                    clazz.accessFlags.unsetFinal();
                }
                clazz.accessFlags.setAbstract();
            }
            clazz.directMethods = this.reachableMethods(clazz.directMethods(), clazz);
            clazz.virtualMethods = this.reachableMethods(clazz.virtualMethods(), clazz);
            clazz.instanceFields = this.reachableFields(clazz.instanceFields());
            clazz.staticFields = this.reachableFields(clazz.staticFields());
        }
        return newClasses;
    }

    private boolean hasDefaultConstructor(DexProgramClass clazz) {
        for (DexEncodedMethod method : clazz.directMethods()) {
            if (!this.isDefaultConstructor(method)) continue;
            return true;
        }
        return false;
    }

    private <S extends PresortedComparable<S>, T extends KeyedDexItem<S>> int firstUnreachableIndex(T[] items, Set<S> live) {
        for (int i = 0; i < items.length; ++i) {
            if (live.contains(((KeyedDexItem)items[i]).getKey())) continue;
            return i;
        }
        return -1;
    }

    private boolean isDefaultConstructor(DexEncodedMethod method) {
        return method.accessFlags.isConstructor() && !method.accessFlags.isStatic() && method.method.proto.parameters.isEmpty();
    }

    private DexEncodedMethod[] reachableMethods(DexEncodedMethod[] methods, DexClass clazz) {
        int i;
        int firstUnreachable = this.firstUnreachableIndex(methods, this.appInfo.liveMethods);
        if (firstUnreachable == -1) {
            return methods;
        }
        ArrayList<DexEncodedMethod> reachableMethods = new ArrayList<DexEncodedMethod>(methods.length);
        for (i = 0; i < firstUnreachable; ++i) {
            reachableMethods.add(methods[i]);
        }
        for (i = firstUnreachable; i < methods.length; ++i) {
            boolean allowAbstract;
            if (this.appInfo.liveMethods.contains(methods[i].getKey())) {
                reachableMethods.add(methods[i]);
                continue;
            }
            if (this.options.debugKeepRules && this.isDefaultConstructor(methods[i])) {
                reachableMethods.add(methods[i].accessFlags.isAbstract() ? methods[i] : methods[i].toMethodThatLogsError(this.application.dexItemFactory));
                continue;
            }
            if (!this.appInfo.targetedMethods.contains(methods[i].getKey())) continue;
            DexEncodedMethod method = methods[i];
            boolean bl = allowAbstract = clazz.accessFlags.isAbstract() && !method.accessFlags.isFinal() && !method.accessFlags.isNative() && !method.accessFlags.isStrict() && !method.accessFlags.isSynchronized();
            assert (!method.accessFlags.isPrivate() && !method.accessFlags.isStatic());
            reachableMethods.add(allowAbstract ? methods[i].toAbstractMethod() : methods[i].toEmptyThrowingMethod());
        }
        return reachableMethods.toArray(new DexEncodedMethod[reachableMethods.size()]);
    }

    private DexEncodedField[] reachableFields(DexEncodedField[] fields) {
        int i;
        int firstUnreachable = this.firstUnreachableIndex(fields, this.appInfo.liveFields);
        if (firstUnreachable == -1) {
            return fields;
        }
        ArrayList<DexEncodedField> reachableFields = new ArrayList<DexEncodedField>(fields.length);
        for (i = 0; i < firstUnreachable; ++i) {
            reachableFields.add(fields[i]);
        }
        for (i = firstUnreachable + 1; i < fields.length; ++i) {
            if (!this.appInfo.liveFields.contains(fields[i].getKey())) continue;
            reachableFields.add(fields[i]);
        }
        return reachableFields.toArray(new DexEncodedField[reachableFields.size()]);
    }
}

