/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.OutputMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

public class InternalOptions {
    public final DexItemFactory itemFactory;
    public final int NOT_SPECIFIED = -1;
    public boolean printTimes = false;
    public boolean skipDebugInfoOpt = false;
    public boolean skipDebugLineNumberOpt = false;
    public boolean skipClassMerging = true;
    public int numberOfThreads = -1;
    public boolean useSmaliSyntax = false;
    public boolean verbose = false;
    public boolean quiet = false;
    public List<String> methodsFilter = ImmutableList.of();
    public int minApiLevel = 1;
    public List<String> logArgumentsFilter = ImmutableList.of();
    public OffOrAuto interfaceMethodDesugaring = OffOrAuto.Off;
    public OffOrAuto tryWithResourcesDesugaring = OffOrAuto.Off;
    public OutputMode outputMode = OutputMode.Indexed;
    public boolean useTreeShaking = true;
    public boolean printUsage = false;
    public Path printUsageFile = null;
    public boolean printCfg = false;
    public String printCfgFile;
    public boolean printSeeds;
    public Path seedsFile;
    public boolean printMapping;
    public Path printMappingFile;
    public boolean printMainDexList;
    public Path printMainDexListFile;
    public boolean ignoreMissingClasses = false;
    public boolean skipMinification = false;
    public String packagePrefix = "";
    public boolean allowAccessModification = true;
    public boolean inlineAccessors = true;
    public boolean removeSwitchMaps = true;
    public boolean disableAssertions = true;
    public final OutlineOptions outline = new OutlineOptions();
    public boolean debugKeepRules = false;
    public final AttributeRemovalOptions attributeRemoval = new AttributeRemovalOptions();
    public boolean allowParameterName = false;
    public boolean debug = false;
    public final TestingOptions testing = new TestingOptions();
    public List<String> classObfuscationDictionary = ImmutableList.of();
    public List<String> obfuscationDictionary = ImmutableList.of();
    public ImmutableList<ProguardConfigurationRule> mainDexKeepRules = ImmutableList.of();
    public boolean minimalMainDex;
    public ImmutableList<ProguardConfigurationRule> keepRules = ImmutableList.of();
    public ImmutableSet<ProguardTypeMatcher> dontWarnPatterns = ImmutableSet.of();
    public String warningInvalidParameterAnnotations = null;

    public InternalOptions() {
        this.itemFactory = new DexItemFactory();
    }

    public InternalOptions(DexItemFactory factory) {
        assert (factory != null);
        this.itemFactory = factory;
    }

    public boolean printWarnings() {
        boolean printed = false;
        if (this.warningInvalidParameterAnnotations != null) {
            System.out.println("Warning: " + this.warningInvalidParameterAnnotations);
            printed = true;
        }
        return printed;
    }

    public boolean hasMethodsFilter() {
        return this.methodsFilter.size() > 0;
    }

    public boolean methodMatchesFilter(DexEncodedMethod method) {
        if (!this.hasMethodsFilter()) {
            return true;
        }
        String qualifiedName = method.qualifiedName();
        return this.methodsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean methodMatchesLogArgumentsFilter(DexEncodedMethod method) {
        if (this.logArgumentsFilter.size() == 0) {
            return false;
        }
        String qualifiedName = method.qualifiedName();
        return this.logArgumentsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean canUseInvokePolymorphic() {
        return this.minApiLevel >= 26;
    }

    public boolean canUseInvokeCustom() {
        return this.minApiLevel >= 26;
    }

    public boolean canUseDefaultAndStaticInterfaceMethods() {
        return this.minApiLevel >= 24;
    }

    public boolean canUseLongCompareAndObjectsNonNull() {
        return this.minApiLevel >= 19;
    }

    public boolean canUseSuppressedExceptions() {
        return this.minApiLevel >= 19;
    }

    public boolean canUsePrivateInterfaceMethods() {
        return this.minApiLevel >= 24;
    }

    public boolean canUseParameterNameAnnotations() {
        return this.minApiLevel >= 26;
    }

    public static class AttributeRemovalOptions {
        public static final String INNER_CLASSES = "InnerClasses";
        public static final String ENCLOSING_METHOD = "EnclosingMethod";
        public static final String SIGNATURE = "Signature";
        public static final String EXCEPTIONS = "Exceptions";
        public static final String SOURCE_DEBUG_EXTENSION = "SourceDebugExtension";
        public static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
        public static final String RUNTIME_INVISBLE_ANNOTATIONS = "RuntimeInvisibleAnnotations";
        public static final String RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS = "RuntimeVisibleParameterAnnotations";
        public static final String RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS = "RuntimeInvisibleParameterAnnotations";
        public static final String RUNTIME_VISIBLE_TYPE_ANNOTATIONS = "RuntimeVisibleTypeAnnotations";
        public static final String RUNTIME_INVISIBLE_TYPE_ANNOTATIONS = "RuntimeInvisibleTypeAnnotations";
        public static final String ANNOTATION_DEFAULT = "AnnotationDefault";
        public boolean innerClasses = false;
        public boolean enclosingMethod = false;
        public boolean signature = false;
        public boolean exceptions = false;
        public boolean sourceDebugExtension = false;
        public boolean runtimeVisibleAnnotations = false;
        public boolean runtimeInvisibleAnnotations = false;
        public boolean runtimeVisibleParameterAnnotations = false;
        public boolean runtimeInvisibleParamterAnnotations = false;
        public boolean runtimeVisibleTypeAnnotations = false;
        public boolean runtimeInvisibleTypeAnnotations = false;
        public boolean annotationDefault = false;

        private AttributeRemovalOptions() {
        }

        public static AttributeRemovalOptions filterOnlySignatures() {
            AttributeRemovalOptions result = new AttributeRemovalOptions();
            result.applyPattern("*");
            result.signature = false;
            return result;
        }

        private boolean update(boolean previous, String text, String[] patterns) {
            for (String pattern : patterns) {
                if (previous) {
                    return true;
                }
                if (pattern.charAt(0) == '!') {
                    if (!this.matches(pattern, 1, text, 0)) continue;
                    break;
                }
                previous = this.matches(pattern, 0, text, 0);
            }
            return previous;
        }

        private boolean matches(String pattern, int patternPos, String text, int textPos) {
            while (patternPos < pattern.length()) {
                char next;
                if ((next = pattern.charAt(patternPos++)) == '*') {
                    while (textPos < text.length()) {
                        if (!this.matches(pattern, patternPos, text, textPos++)) continue;
                        return true;
                    }
                    return patternPos >= pattern.length();
                }
                if (textPos >= text.length() || text.charAt(textPos) != next) {
                    return false;
                }
                ++textPos;
            }
            return textPos == text.length();
        }

        public void applyPattern(String pattern) {
            String[] patterns = pattern.split(",");
            this.innerClasses = this.update(this.innerClasses, INNER_CLASSES, patterns);
            this.enclosingMethod = this.update(this.enclosingMethod, ENCLOSING_METHOD, patterns);
            this.signature = this.update(this.signature, SIGNATURE, patterns);
            this.exceptions = this.update(this.exceptions, EXCEPTIONS, patterns);
            this.sourceDebugExtension = this.update(this.sourceDebugExtension, SOURCE_DEBUG_EXTENSION, patterns);
            this.runtimeVisibleAnnotations = this.update(this.runtimeVisibleAnnotations, RUNTIME_VISIBLE_ANNOTATIONS, patterns);
            this.runtimeInvisibleAnnotations = this.update(this.runtimeInvisibleAnnotations, RUNTIME_INVISBLE_ANNOTATIONS, patterns);
            this.runtimeVisibleParameterAnnotations = this.update(this.runtimeVisibleParameterAnnotations, RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, patterns);
            this.runtimeInvisibleParamterAnnotations = this.update(this.runtimeInvisibleParamterAnnotations, RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS, patterns);
            this.runtimeVisibleTypeAnnotations = this.update(this.runtimeVisibleTypeAnnotations, RUNTIME_VISIBLE_TYPE_ANNOTATIONS, patterns);
            this.runtimeInvisibleTypeAnnotations = this.update(this.runtimeInvisibleTypeAnnotations, RUNTIME_INVISIBLE_TYPE_ANNOTATIONS, patterns);
            this.annotationDefault = this.update(this.annotationDefault, ANNOTATION_DEFAULT, patterns);
        }

        public void ensureValid(boolean isMinifying) {
            if (this.innerClasses && !this.enclosingMethod) {
                throw new CompilationError("Attribute InnerClasses requires EnclosingMethod attribute. Check -keepattributes directive.");
            }
            if (!this.innerClasses && this.enclosingMethod) {
                throw new CompilationError("Attribute EnclosingMethod requires InnerClasses attribute. Check -keepattributes directive.");
            }
            if (this.signature && !this.innerClasses) {
                throw new CompilationError("Attribute Signature requires InnerClasses attribute. Check -keepattributes directive.");
            }
            if (this.signature && isMinifying) {
                throw new CompilationError("Attribute Signature cannot be kept when minifying. Check -keepattributes directive.");
            }
        }
    }

    public static class TestingOptions {
        public Function<List<DexEncodedMethod>, List<DexEncodedMethod>> irOrdering;
    }

    public static class OutlineOptions {
        public boolean enabled = true;
        public static final String className = "r8.GeneratedOutlineSupport";
        public String methodPrefix = "outline";
        public int minSize = 3;
        public int maxSize = 99;
        public int threshold = 20;
    }
}

