/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;

public class JarState {
    public static final Type REFERENCE_TYPE = Type.getObjectType((String)"<any reference>");
    public static final Type OBJECT_TYPE = Type.getObjectType((String)"<any object>");
    public static final Type ARRAY_TYPE = Type.getObjectType((String)"[<any array>");
    public static final Type NULL_TYPE = Type.getObjectType((String)"<null>");
    private final int startOfStack;
    private int topOfStack;
    private final int localsSize;
    private final Local[] locals;
    private final Map<LocalVariableNode, DebugLocalInfo> localVariables;
    private final Multimap<LabelNode, LocalVariableNode> localVariableStartPoints;
    private final Multimap<LabelNode, LocalVariableNode> localVariableEndPoints;
    private final Deque<Slot> stack = new ArrayDeque<Slot>();
    private final Map<Integer, Snapshot> targetStates = new HashMap<Integer, Snapshot>();

    public JarState(int maxLocals, Map<LocalVariableNode, DebugLocalInfo> localVariables) {
        int localsRegistersSize = maxLocals * 3;
        this.localsSize = maxLocals;
        this.locals = new Local[localsRegistersSize];
        this.topOfStack = this.startOfStack = localsRegistersSize;
        this.localVariables = localVariables;
        this.localVariableStartPoints = HashMultimap.create();
        this.localVariableEndPoints = HashMultimap.create();
        this.populateLocalTables();
    }

    private void populateLocalTables() {
        for (LocalVariableNode node : this.localVariables.keySet()) {
            if (node.start == node.end) continue;
            this.localVariableStartPoints.put((Object)node.start, (Object)node);
            this.localVariableEndPoints.put((Object)node.end, (Object)node);
        }
    }

    public List<Local> openLocals(LabelNode label) {
        Collection nodes = this.localVariableStartPoints.get((Object)label);
        ArrayList<Local> locals = new ArrayList<Local>(nodes.size());
        for (LocalVariableNode node : nodes) {
            locals.add(this.setLocal(node.index, Type.getType((String)node.desc), this.localVariables.get(node)));
        }
        locals.sort(Comparator.comparingInt(local -> local.slot.register));
        return locals;
    }

    public List<Local> getLocalsToClose(LabelNode label) {
        Collection nodes = this.localVariableEndPoints.get((Object)label);
        ArrayList<Local> locals = new ArrayList<Local>(nodes.size());
        for (LocalVariableNode node : nodes) {
            Type type = Type.getType((String)node.desc);
            int register = this.getLocalRegister(node.index, type);
            Local local2 = this.getLocalForRegister(register);
            assert (local2 != null);
            locals.add(local2);
        }
        locals.sort(Comparator.comparingInt(local -> local.slot.register));
        return locals;
    }

    public void closeLocals(List<Local> localsToClose) {
        for (Local local : localsToClose) {
            assert (local != null);
            assert (local == this.getLocalForRegister(local.slot.register));
            this.setLocalForRegister(local.slot.register, local.slot.type, null);
        }
    }

    public ImmutableList<Local> getLocals() {
        ImmutableList.Builder nonNullLocals = ImmutableList.builder();
        for (Local local : this.locals) {
            if (local == null) continue;
            nonNullLocals.add((Object)local);
        }
        return nonNullLocals.build();
    }

    int getLocalRegister(int index, Type type) {
        assert (index < this.localsSize);
        if (type.getSort() == 10 || type.getSort() == 9) {
            return index;
        }
        return Slot.isCategory1(type) ? index + this.localsSize : index + 2 * this.localsSize;
    }

    public DebugLocalInfo getLocalInfoForRegister(int register) {
        if (register >= this.locals.length) {
            return null;
        }
        Local local = this.getLocalForRegister(register);
        return local == null ? null : local.info;
    }

    private Local getLocalForRegister(int register) {
        return this.locals[register];
    }

    private Local getLocal(int index, Type type) {
        return this.getLocalForRegister(this.getLocalRegister(index, type));
    }

    private Local setLocal(int index, Type type, DebugLocalInfo info) {
        return this.setLocalForRegister(this.getLocalRegister(index, type), type, info);
    }

    private Local setLocalForRegister(int register, Type type, DebugLocalInfo info) {
        Local local;
        Slot slot = new Slot(register, type);
        this.locals[register] = local = new Local(slot, info);
        return local;
    }

    public int writeLocal(int index, Type type) {
        assert (type != null);
        Local local = this.getLocal(index, type);
        assert (local == null || local.info == null || local.slot.isCompatibleWith(type));
        if (local == null || local.info == null && !local.slot.type.equals((Object)type)) {
            local = this.setLocal(index, type, null);
        }
        return local.slot.register;
    }

    public Slot readLocal(int index, Type type) {
        Local local = this.getLocal(index, type);
        assert (local != null);
        assert (local.slot.isCompatibleWith(type));
        return local.slot;
    }

    public int push(Type type) {
        assert (type != null);
        int top = this.topOfStack;
        this.topOfStack += 2;
        Slot slot = new Slot(top, type);
        this.stack.push(slot);
        return top;
    }

    public Slot peek() {
        return this.stack.peek();
    }

    public Slot peek(Type type) {
        Slot slot = this.stack.peek();
        assert (slot.isCompatibleWith(type));
        return slot;
    }

    public Slot pop() {
        assert (this.topOfStack > this.startOfStack);
        this.topOfStack -= 2;
        Slot slot = this.stack.pop();
        assert (slot.type != null);
        assert (slot.register == this.topOfStack);
        return slot;
    }

    public Slot pop(Type type) {
        Slot slot = this.pop();
        assert (slot.isCompatibleWith(type));
        return slot;
    }

    public Slot[] popReverse(int count) {
        Slot[] slots = new Slot[count];
        for (int i = count - 1; i >= 0; --i) {
            slots[i] = this.pop();
        }
        return slots;
    }

    public Slot[] popReverse(int count, Type type) {
        Slot[] slots = this.popReverse(count);
        assert (JarState.verifySlots(slots, type));
        return slots;
    }

    public boolean hasState(int offset) {
        return this.targetStates.get(offset) != null;
    }

    public void restoreState(int offset) {
        Snapshot snapshot = this.targetStates.get(offset);
        assert (snapshot != null);
        assert (this.locals.length == snapshot.locals.length);
        System.arraycopy(snapshot.locals, 0, this.locals, 0, this.locals.length);
        this.stack.clear();
        this.stack.addAll((Collection<Slot>)snapshot.stack);
        this.topOfStack = this.startOfStack + 2 * this.stack.size();
    }

    public boolean recordStateForTarget(int target, JarSourceCode source) {
        return this.recordStateForTarget(target, (Local[])this.locals.clone(), (ImmutableList<Slot>)ImmutableList.copyOf(this.stack), source);
    }

    public boolean recordStateForExceptionalTarget(int target, JarSourceCode source) {
        return this.recordStateForTarget(target, (Local[])this.locals.clone(), (ImmutableList<Slot>)ImmutableList.of(), source);
    }

    private boolean recordStateForTarget(int target, Local[] locals, ImmutableList<Slot> stack, JarSourceCode source) {
        Snapshot snapshot;
        if (!this.localVariables.isEmpty()) {
            for (int i = 0; i < locals.length; ++i) {
                if (locals[i] == null) continue;
                locals[i] = new Local(locals[i].slot, null);
            }
            for (Map.Entry<LocalVariableNode, DebugLocalInfo> entry : this.localVariables.entrySet()) {
                LocalVariableNode node = entry.getKey();
                int startOffset = source.getOffset((AbstractInsnNode)node.start);
                int endOffset = source.getOffset((AbstractInsnNode)node.end);
                if (startOffset > target || target >= endOffset) continue;
                int register = this.getLocalRegister(node.index, Type.getType((String)node.desc));
                Local local = locals[register];
                locals[register] = new Local(local.slot, entry.getValue());
            }
        }
        if ((snapshot = this.targetStates.get(target)) != null) {
            Local[] newLocals = this.mergeLocals(snapshot.locals, locals);
            ImmutableList<Slot> newStack = this.mergeStacks(snapshot.stack, stack);
            if (newLocals != snapshot.locals || newStack != snapshot.stack) {
                this.targetStates.put(target, new Snapshot(newLocals, newStack));
                return true;
            }
            return false;
        }
        this.targetStates.put(target, new Snapshot(locals, stack));
        return true;
    }

    private ImmutableList<Slot> mergeStacks(ImmutableList<Slot> currentStack, ImmutableList<Slot> newStack) {
        assert (currentStack.size() == newStack.size());
        ArrayList<Object> mergedStack = null;
        for (int i = 0; i < currentStack.size(); ++i) {
            if (((Slot)currentStack.get((int)i)).type == NULL_TYPE && ((Slot)newStack.get((int)i)).type != NULL_TYPE) {
                if (mergedStack == null) {
                    mergedStack = new ArrayList<Object>();
                    mergedStack.addAll((Collection<Object>)currentStack.subList(0, i));
                }
                mergedStack.add(newStack.get(i));
                continue;
            }
            if (mergedStack == null) continue;
            assert (((Slot)currentStack.get(i)).isCompatibleWith(((Slot)newStack.get((int)i)).type));
            mergedStack.add(currentStack.get(i));
        }
        return mergedStack != null ? ImmutableList.copyOf(mergedStack) : currentStack;
    }

    private Local[] mergeLocals(Local[] currentLocals, Local[] newLocals) {
        assert (currentLocals.length == newLocals.length);
        Local[] mergedLocals = null;
        for (int i = 0; i < currentLocals.length; ++i) {
            Local currentLocal = currentLocals[i];
            Local newLocal = newLocals[i];
            if (currentLocal == null || newLocal == null) continue;
            assert (currentLocal.info == newLocal.info);
            if (currentLocal.slot.type == NULL_TYPE && newLocal.slot.type != NULL_TYPE) {
                if (mergedLocals == null) {
                    mergedLocals = new Local[currentLocals.length];
                    System.arraycopy(currentLocals, 0, mergedLocals, 0, i);
                }
                Slot newSlot = new Slot(newLocal.slot.register, newLocal.slot.type);
                mergedLocals[i] = new Local(newSlot, newLocal.info);
                continue;
            }
            if (mergedLocals == null) continue;
            mergedLocals[i] = currentLocals[i];
        }
        return mergedLocals != null ? mergedLocals : currentLocals;
    }

    private static boolean verifyStack(List<Slot> stack, List<Slot> other) {
        assert (stack.size() == other.size());
        int i = 0;
        for (Slot slot : stack) {
            assert (slot.isCompatibleWith(other.get((int)i++).type));
        }
        return true;
    }

    private static boolean verifySlots(Slot[] slots, Type type) {
        for (Slot slot : slots) {
            assert (slot.isCompatibleWith(type));
        }
        return true;
    }

    public String toString() {
        return "locals: " + JarState.localsToString(Arrays.asList(this.locals)) + ", stack: " + JarState.stackToString(this.stack);
    }

    public static String stackToString(Collection<Slot> stack) {
        ArrayList<String> strings = new ArrayList<String>(stack.size());
        for (Slot slot : stack) {
            strings.add(slot.type.toString());
        }
        StringBuilder builder = new StringBuilder("{ ");
        for (int i = strings.size() - 1; i >= 0; --i) {
            builder.append((String)strings.get(i));
            if (i <= 0) continue;
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public static String localsToString(Collection<Local> locals) {
        StringBuilder builder = new StringBuilder("{ ");
        boolean first = true;
        for (Local local : locals) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            if (local == null) {
                builder.append("_");
                continue;
            }
            if (local.info != null) {
                builder.append(local.info);
                continue;
            }
            builder.append(local.slot.type.toString());
        }
        builder.append(" }");
        return builder.toString();
    }

    private static class Snapshot {
        public final Local[] locals;
        public final ImmutableList<Slot> stack;

        public Snapshot(Local[] locals, ImmutableList<Slot> stack) {
            this.locals = locals;
            this.stack = stack;
        }

        public String toString() {
            return "locals: " + JarState.localsToString(Arrays.asList(this.locals)) + ", stack: " + JarState.stackToString(this.stack);
        }
    }

    public static class Local {
        final Slot slot;
        final DebugLocalInfo info;

        public Local(Slot slot, DebugLocalInfo info) {
            this.slot = slot;
            this.info = info;
        }
    }

    public static class Slot {
        public final int register;
        public final Type type;

        public String toString() {
            return "r" + this.register + ":" + this.type;
        }

        public Slot(int register, Type type) {
            assert (type != REFERENCE_TYPE);
            assert (type != OBJECT_TYPE);
            assert (type != ARRAY_TYPE);
            this.register = register;
            this.type = type;
        }

        public boolean isCompatibleWith(Type other) {
            return Slot.isCompatible(this.type, other);
        }

        public boolean isCategory1() {
            return Slot.isCategory1(this.type);
        }

        public Type getArrayElementType() {
            assert (this.type == NULL_TYPE || this.type == ARRAY_TYPE || this.type.getSort() == 9);
            if (this.type == NULL_TYPE) {
                return null;
            }
            return Slot.getArrayElementType(this.type);
        }

        public static boolean isCategory1(Type type) {
            return type != Type.LONG_TYPE && type != Type.DOUBLE_TYPE;
        }

        public static boolean isCompatible(Type type, Type other) {
            assert (type != REFERENCE_TYPE);
            assert (type != OBJECT_TYPE);
            assert (type != ARRAY_TYPE);
            int sort = type.getSort();
            int otherSort = other.getSort();
            if (Slot.isReferenceCompatible(type, other)) {
                return true;
            }
            if (Slot.isIntCompatible(sort)) {
                return Slot.isIntCompatible(otherSort);
            }
            if (Slot.isIntCompatible(otherSort)) {
                return Slot.isIntCompatible(sort);
            }
            return type.equals((Object)other);
        }

        private static Type getArrayElementType(Type type) {
            String desc = type.getDescriptor();
            assert (desc.charAt(0) == '[');
            return Type.getType((String)desc.substring(1));
        }

        private static boolean isIntCompatible(int sort) {
            return 1 <= sort && sort <= 5;
        }

        private static boolean isReferenceCompatible(Type type, Type other) {
            int sort = type.getSort();
            int otherSort = other.getSort();
            if (other == REFERENCE_TYPE) {
                return sort == 10 || sort == 9;
            }
            if (other == OBJECT_TYPE) {
                return sort == 10;
            }
            if (other == ARRAY_TYPE) {
                return type == NULL_TYPE || sort == 9;
            }
            return sort == 10 && otherSort == 9 || sort == 9 && otherSort == 10 || sort == 10 && otherSort == 10 || sort == 9 && otherSort == 9 && Slot.isReferenceCompatible(Slot.getArrayElementType(type), Slot.getArrayElementType(other));
        }
    }
}

