/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.DefaultMethodsHelper;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.synthetic.ForwardMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ClassProcessor {
    private final InterfaceMethodRewriter rewriter;
    private final Set<DexClass> processedClasses = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> createdMethods = new IdentityHashMap<DexEncodedMethod, DexEncodedMethod>();
    private final Map<DexType, DefaultMethodsHelper.Collection> cache = new IdentityHashMap<DexType, DefaultMethodsHelper.Collection>();

    ClassProcessor(InterfaceMethodRewriter rewriter) {
        this.rewriter = rewriter;
    }

    final Set<DexEncodedMethod> getForwardMethods() {
        return this.createdMethods.keySet();
    }

    final void process(DexClass clazz) {
        if (clazz.isInterface()) {
            throw new CompilationError("Interface in superclass chain.");
        }
        if (!clazz.isProgramClass()) {
            return;
        }
        if (!this.processedClasses.add(clazz)) {
            return;
        }
        DexType superType = clazz.superType;
        if (superType != null && superType != this.rewriter.factory.objectType) {
            this.process(this.rewriter.findRequiredClass(superType));
        }
        if (clazz.interfaces.isEmpty()) {
            return;
        }
        List<DexEncodedMethod> methodsToImplement = this.collectMethodsToImplement(clazz);
        if (methodsToImplement.isEmpty()) {
            return;
        }
        DexEncodedMethod[] existing = clazz.virtualMethods();
        clazz.setVirtualMethods(new DexEncodedMethod[existing.length + methodsToImplement.size()]);
        System.arraycopy(existing, 0, clazz.virtualMethods(), 0, existing.length);
        for (int i = 0; i < methodsToImplement.size(); ++i) {
            DexEncodedMethod newMethod;
            DexEncodedMethod method = methodsToImplement.get(i);
            assert (method.accessFlags.isPublic() && !method.accessFlags.isAbstract());
            clazz.virtualMethods()[existing.length + i] = newMethod = this.addForwardingMethod(method, clazz);
            this.createdMethods.put(newMethod, method);
        }
    }

    private DexEncodedMethod addForwardingMethod(DexEncodedMethod defaultMethod, DexClass clazz) {
        DexMethod method = defaultMethod.method;
        assert (!this.rewriter.findRequiredClass(method.holder).isLibraryClass());
        DexMethod newMethod = this.rewriter.factory.createMethod(clazz.type, method.proto, method.name);
        DexAccessFlags newFlags = new DexAccessFlags(defaultMethod.accessFlags.get());
        return new DexEncodedMethod(newMethod, newFlags, defaultMethod.annotations, defaultMethod.parameterAnnotations, new SynthesizedCode(new ForwardMethodSourceCode(clazz.type, method.proto, null, this.rewriter.defaultAsMethodOfCompanionClass(method), Invoke.Type.STATIC)));
    }

    private List<DexEncodedMethod> collectMethodsToImplement(DexClass clazz) {
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass current = clazz;
        while (true) {
            for (DexType type : current.interfaces.values) {
                helper.merge(this.getOrCreateInterfaceInfo(type));
            }
            DexType superType = current.superType;
            if (superType == null || superType == this.rewriter.factory.objectType) break;
            current = this.rewriter.findRequiredClass(superType);
        }
        List<DexEncodedMethod> candidates = helper.createCandidatesList();
        if (candidates.isEmpty()) {
            return candidates;
        }
        ArrayList<DexEncodedMethod> toBeImplemented = new ArrayList<DexEncodedMethod>(candidates.size());
        current = clazz;
        while (true) {
            this.hideCandidates(current.virtualMethods(), candidates, toBeImplemented);
            if (candidates.isEmpty()) {
                return toBeImplemented;
            }
            DexType superType = current.superType;
            if (superType == null || superType == this.rewriter.factory.objectType) {
                toBeImplemented.addAll(candidates);
                return toBeImplemented;
            }
            current = this.rewriter.findRequiredClass(superType);
        }
    }

    private void hideCandidates(DexEncodedMethod[] virtualMethods, List<DexEncodedMethod> candidates, List<DexEncodedMethod> toBeImplemented) {
        Iterator<DexEncodedMethod> it = candidates.iterator();
        block0: while (it.hasNext()) {
            DexEncodedMethod candidate = it.next();
            for (DexEncodedMethod encoded : virtualMethods) {
                if (!candidate.method.match(encoded)) continue;
                DexEncodedMethod basedOnCandidate = this.createdMethods.get(encoded);
                if (basedOnCandidate != null && basedOnCandidate != candidate) {
                    toBeImplemented.add(candidate);
                }
                it.remove();
                continue block0;
            }
        }
    }

    private DefaultMethodsHelper.Collection getOrCreateInterfaceInfo(DexType iface) {
        DefaultMethodsHelper.Collection collection = this.cache.get(iface);
        if (collection != null) {
            return collection;
        }
        collection = this.createInterfaceInfo(iface);
        this.cache.put(iface, collection);
        return collection;
    }

    private DefaultMethodsHelper.Collection createInterfaceInfo(DexType iface) {
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass clazz = this.rewriter.findRequiredClass(iface);
        if (!clazz.isInterface()) {
            throw new CompilationError("Type " + iface.toSourceString() + " is expected to be an interface.");
        }
        if (clazz.isLibraryClass()) {
            return DefaultMethodsHelper.Collection.EMPTY;
        }
        for (DexType dexType : clazz.interfaces.values) {
            helper.merge(this.getOrCreateInterfaceInfo(dexType));
        }
        for (DexItem dexItem : clazz.virtualMethods()) {
            helper.hideMatches(((DexEncodedMethod)dexItem).method);
        }
        for (DexItem dexItem : clazz.virtualMethods()) {
            if (!this.rewriter.isDefaultMethod((DexEncodedMethod)dexItem)) continue;
            helper.addDefaultMethod((DexEncodedMethod)dexItem);
        }
        return helper.wrapInCollection();
    }
}

