/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v1;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.builder.internal.aapt.AbstractProcessExecutionAapt;
import com.android.builder.png.QueuedCruncher;
import com.android.ide.common.internal.ResourceCompilationException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.repository.Revision;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AaptV1
extends AbstractProcessExecutionAapt {
    private static final long AUTO_THREAD_SHUTDOWN_MS = 250L;
    public static final Revision VERSION_FOR_SERVER_AAPT = new Revision(22, 0, 1);
    private final BuildToolInfo buildToolInfo;
    private final QueuedCruncher cruncher;
    private final Executor waitExecutor;
    private final PngProcessMode processMode;
    private final Integer cruncherKey;

    public AaptV1(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, ILogger logger, PngProcessMode processMode, int cruncherProcesses) {
        super(processExecutor, processOutputHandler);
        this.buildToolInfo = buildToolInfo;
        this.waitExecutor = new ThreadPoolExecutor(0, 1, 250L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.processMode = processMode;
        this.cruncher = QueuedCruncher.builder().executablePath(this.getAaptExecutablePath()).logger(logger).numberOfProcesses(cruncherProcesses).build();
        this.cruncherKey = this.cruncher != null ? Integer.valueOf(this.cruncher.start()) : null;
    }

    @Override
    protected ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig config) throws AaptException {
        List<String> additionalParameters;
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("package");
        if (config.isVerbose()) {
            builder.addArgs("-v");
        }
        builder.addArgs("-f");
        builder.addArgs("--no-crunch");
        IAndroidTarget target = config.getAndroidTarget();
        Preconditions.checkNotNull((Object)target);
        builder.addArgs("-I", target.getPath(1));
        File manifestFile = config.getManifestFile();
        Preconditions.checkNotNull((Object)manifestFile);
        builder.addArgs("-M", FileUtils.toExportableSystemDependentPath((File)manifestFile));
        if (config.getResourceDir() != null) {
            builder.addArgs("-S", config.getResourceDir().getAbsolutePath());
        }
        if (config.getSourceOutputDir() != null) {
            builder.addArgs("-m");
            builder.addArgs("-J", FileUtils.toExportableSystemDependentPath((File)config.getSourceOutputDir()));
        }
        if (config.getResourceOutputApk() != null) {
            builder.addArgs("-F", config.getResourceOutputApk().getAbsolutePath());
        }
        if (config.getProguardOutputFile() != null) {
            builder.addArgs("-G", FileUtils.toExportableSystemDependentPath((File)config.getProguardOutputFile()));
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.addArgs("-D", FileUtils.toExportableSystemDependentPath((File)config.getMainDexListProguardOutputFile()));
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                builder.addArgs("--split", split);
            }
        }
        ILogger logger = config.getLogger();
        Preconditions.checkNotNull((Object)logger);
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.addArgs("--custom-package", config.getCustomPackageForR());
            logger.verbose("Custom package for R class: '%s'", new Object[]{config.getCustomPackageForR()});
        }
        if (config.isPseudoLocalize()) {
            builder.addArgs("--pseudo-localize");
        }
        boolean generateFinalIds = true;
        if (config.getVariantType() == VariantType.LIBRARY) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.addArgs("--non-constant-id");
        }
        AaptOptions options = config.getOptions();
        Preconditions.checkNotNull((Object)options);
        if (config.getOptions().getFailOnMissingConfigEntry()) {
            builder.addArgs("--error-on-missing-config-entry");
        }
        builder.addArgs("-0", "apk");
        Collection<String> noCompressList = config.getOptions().getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.addArgs("-0", noCompress);
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addArgs(additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        resourceConfigs.addAll(config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        if (preferredDensity != null && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)), new Object[0]);
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.", new Object[0]);
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.addArgs("-c", joiner.join((Iterable)otherResourceConfigs));
        }
        if (preferredDensity != null) {
            builder.addArgs("--preferred-density", preferredDensity);
        }
        if (!(config.getSymbolOutputDir() == null || config.getVariantType() != VariantType.LIBRARY && config.getLibrarySymbolTableFiles().isEmpty())) {
            builder.addArgs("--output-text-symbols", FileUtils.toExportableSystemDependentPath((File)config.getSymbolOutputDir()));
        }
        builder.addArgs("--no-version-vectors");
        return builder;
    }

    public void close() throws IOException {
        if (this.cruncher != null && this.cruncherKey != null) {
            try {
                this.cruncher.end(this.cruncherKey);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public ListenableFuture<File> compile(CompileResourceRequest request) throws AaptException {
        ListenableFuture<File> futureResult;
        if (ResourceFolderType.getFolderType((String)request.getInput().getParentFile().getName()) == ResourceFolderType.RAW) {
            return this.copyFile(request);
        }
        if (this.cruncher == null || this.cruncherKey == null) {
            return super.compile(request);
        }
        Preconditions.checkArgument((boolean)request.getInput().isFile(), (String)"Input file needs to be a normal file.\nInput file: %s", (Object)request.getInput().getAbsolutePath());
        Preconditions.checkArgument((boolean)request.getOutput().isDirectory(), (String)"Output for resource compilation needs to be a directory.\nOutput: %s", (Object)request.getOutput().getAbsolutePath());
        SettableFuture actualResult = SettableFuture.create();
        if (!this.processMode.shouldProcess(request.getInput())) {
            return this.copyFile(request);
        }
        try {
            futureResult = this.cruncher.compile(this.cruncherKey, request, null);
        }
        catch (ResourceCompilationException e) {
            throw new AaptException(e, String.format("Failed to crunch file '%s' into '%s'", request.getInput().getAbsolutePath(), this.compileOutputFor(request).getAbsolutePath()), new Object[0]);
        }
        futureResult.addListener(() -> {
            File result;
            try {
                result = (File)futureResult.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                actualResult.setException((Throwable)e);
                return;
            }
            catch (ExecutionException e) {
                actualResult.setException((Throwable)e);
                return;
            }
            if (request.getInput().getName().endsWith(".9.png")) {
                actualResult.set((Object)result);
                return;
            }
            if (result != null && request.getInput().length() < result.length()) {
                try {
                    Files.copy((File)request.getInput(), (File)result);
                }
                catch (IOException e) {
                    actualResult.setException((Throwable)e);
                    return;
                }
            }
            actualResult.set((Object)result);
        }, this.waitExecutor);
        return actualResult;
    }

    private ListenableFuture<File> copyFile(CompileResourceRequest request) throws AaptException {
        Preconditions.checkArgument((boolean)request.getInput().isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)request.getOutput().isDirectory(), (Object)"!output.isDirectory()");
        File outFile = this.compileOutputFor(request);
        try {
            FileUtils.copyFile((File)request.getInput(), (File)outFile);
        }
        catch (IOException e) {
            throw new AaptException("Could not copy file", new Object[]{e});
        }
        return Futures.immediateFuture((Object)outFile);
    }

    @Override
    protected AbstractProcessExecutionAapt.CompileInvocation makeCompileProcessBuilder(CompileResourceRequest request) throws AaptException {
        Preconditions.checkArgument((boolean)request.getInput().isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)request.getOutput().isDirectory(), (Object)"!directory.isDirectory()");
        if (!request.getInput().getName().endsWith(".png")) {
            return null;
        }
        if (!this.processMode.shouldProcess(request.getInput())) {
            return null;
        }
        File outputFile = this.compileOutputFor(request);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getAaptExecutablePath());
        builder.addArgs("singleCrunch");
        builder.addArgs("-i", request.getInput().getAbsolutePath());
        builder.addArgs("-o", outputFile.getAbsolutePath());
        return new AbstractProcessExecutionAapt.CompileInvocation(builder, outputFile);
    }

    public File compileOutputFor(CompileResourceRequest request) {
        File parentDir = new File(request.getOutput(), request.getFolderName());
        FileUtils.mkdirs((File)parentDir);
        return new File(parentDir, request.getInput().getName());
    }

    private String getAaptExecutablePath() {
        String aapt = this.buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing on '" + aapt + "'");
        }
        return aapt;
    }

    public static enum PngProcessMode {
        ALL{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".png");
            }
        }
        ,
        NO_CRUNCH{

            @Override
            public boolean shouldProcess(File file) {
                return file.getName().endsWith(".9.png");
            }
        };


        public abstract boolean shouldProcess(File var1);
    }
}

