/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.R8;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;

public class Disassemble {
    public static void main(String[] args) throws IOException, ProguardRuleParserException, CompilationException, ExecutionException {
        DisassembleCommand.Builder builder = DisassembleCommand.parse(args);
        DisassembleCommand command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(DisassembleCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("R8 v0.0.1");
            return;
        }
        R8.disassemble(command);
    }

    public static class DisassembleCommand
    extends BaseCommand {
        private final Path outputPath;
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: disasm [options] <input-files>", (Object)" where <input-files> are dex files", (Object)" and options are:", (Object)"  --smali                 # Disassemble using smali syntax.", (Object)"  --pg-map <file>         # Proguard map <file> for mapping names.", (Object)"  --version               # Print the version of r8.", (Object)"  --help                  # Print this message."));
        private final boolean useSmali;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) throws CompilationException, IOException {
            Builder builder = DisassembleCommand.builder();
            DisassembleCommand.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--smali")) {
                    builder.setUseSmali(true);
                    continue;
                }
                if (arg.equals("--pg-map")) {
                    builder.setProguardMapFile(Paths.get(args[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--output")) {
                    String outputPath = args[++i];
                    builder.setOutputPath(Paths.get(outputPath, new String[0]));
                    continue;
                }
                if (arg.startsWith("--")) {
                    throw new CompilationException("Unknown option: " + arg);
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private DisassembleCommand(AndroidApp inputApp, Path outputPath, boolean useSmali) {
            super(inputApp);
            this.outputPath = outputPath;
            this.useSmali = useSmali;
        }

        private DisassembleCommand(boolean printHelp, boolean printVersion) {
            super(printHelp, printVersion);
            this.outputPath = null;
            this.useSmali = false;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public boolean useSmali() {
            return this.useSmali;
        }

        @Override
        InternalOptions getInternalOptions() {
            InternalOptions internal = new InternalOptions();
            internal.useSmaliSyntax = this.useSmali;
            return internal;
        }

        public static class Builder
        extends BaseCommand.Builder<DisassembleCommand, Builder> {
            private Path outputPath = null;
            private boolean useSmali = false;

            @Override
            Builder self() {
                return this;
            }

            public Builder setProguardMapFile(Path path) {
                this.getAppBuilder().setProguardMapFile(path);
                return this;
            }

            public Path getOutputPath() {
                return this.outputPath;
            }

            public Builder setOutputPath(Path outputPath) {
                this.outputPath = outputPath;
                return this;
            }

            public Builder setUseSmali(boolean useSmali) {
                this.useSmali = useSmali;
                return this;
            }

            @Override
            public DisassembleCommand build() throws CompilationException, IOException {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new DisassembleCommand(this.isPrintHelp(), this.isPrintVersion());
                }
                this.validate();
                return new DisassembleCommand(this.getAppBuilder().build(), this.getOutputPath(), this.useSmali);
            }
        }
    }
}

