/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public class MainDexList {
    public static Set<DexType> parse(Path path, DexItemFactory itemFactory) throws IOException {
        try (Closer closer = Closer.create();){
            Set<DexType> set = MainDexList.parse((InputStream)closer.register((Closeable)Files.newInputStream(path, new OpenOption[0])), itemFactory);
            return set;
        }
    }

    public static DexType parse(String clazz, DexItemFactory itemFactory) {
        if (!clazz.endsWith(".class")) {
            throw new CompilationError("Illegal main-dex-list entry '" + clazz + "'.");
        }
        String name = clazz.substring(0, clazz.length() - ".class".length());
        if (name.contains(".")) {
            throw new CompilationError("Illegal main-dex-list entry '" + clazz + "'.");
        }
        String descriptor = "L" + name + ";";
        return itemFactory.createType(descriptor);
    }

    public static Set<DexType> parse(InputStream input, DexItemFactory itemFactory) {
        Set result = Sets.newIdentityHashSet();
        try {
            String line;
            BufferedReader file = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while ((line = file.readLine()) != null) {
                result.add(MainDexList.parse(line, itemFactory));
            }
        }
        catch (IOException e) {
            throw new CompilationError("Cannot load main-dex-list.");
        }
        return result;
    }
}

