/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexingType;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.errors.CompilationError;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

final class D8DexArchiveMerger
implements DexArchiveMerger {
    private final OutputStream errorStream;
    private final int minSdkVersion;
    private final CompilationMode compilationMode;

    public D8DexArchiveMerger(OutputStream errorStream, int minSdkVersion, CompilationMode compilationMode) {
        this.errorStream = errorStream;
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = compilationMode;
    }

    @Override
    public void mergeDexArchives(Iterable<Path> inputs, Path outputDir, Path mainDexClasses, DexingType dexingType) throws DexArchiveMergerException {
        if (Iterables.isEmpty(inputs)) {
            return;
        }
        D8Command.Builder builder = D8Command.builder();
        for (Path input : inputs) {
            try {
                DexArchive archive = DexArchives.fromInput(input);
                Throwable throwable = null;
                try {
                    for (DexArchiveEntry dexArchiveEntry : archive.getFiles()) {
                        builder.addDexProgramData(new byte[][]{dexArchiveEntry.getDexFileContent()});
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (archive == null) continue;
                    if (throwable != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    archive.close();
                }
            }
            catch (IOException e) {
                throw new DexArchiveMergerException(e);
            }
        }
        try {
            if (mainDexClasses != null) {
                builder.addMainDexListFiles(mainDexClasses);
            }
            ((D8Command.Builder)((D8Command.Builder)builder.setMinApiLevel(this.minSdkVersion)).setMode(this.compilationMode)).setOutputPath(outputDir);
            D8.run(builder.build());
        }
        catch (CompilationException | CompilationError | IOException e) {
            DexArchiveMergerException exception = new DexArchiveMergerException(e);
            try {
                this.errorStream.write(e.getMessage().getBytes());
            }
            catch (IOException ex) {
                System.err.println(e.getMessage());
                exception.addSuppressed(ex);
            }
            throw exception;
        }
    }
}

