/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;

public class ExtractMarker {
    public static void main(String[] args) throws IOException, ProguardRuleParserException, CompilationException, ExecutionException {
        Command.Builder builder = Command.parse(args);
        Command command = builder.build();
        if (command.isPrintHelp()) {
            System.out.println(Command.USAGE_MESSAGE);
            return;
        }
        AndroidApp app = command.getInputApp();
        DexApplication dexApp = new ApplicationReader(app, new InternalOptions(), new Timing("ExtractMarker")).read();
        Marker readMarker = dexApp.dexItemFactory.extractMarker();
        if (readMarker == null) {
            System.out.println("D8/R8 marker not found.");
            System.exit(1);
        } else {
            System.out.println(readMarker.toString());
            System.exit(0);
        }
    }

    private static class Command
    extends BaseCommand {
        static final String USAGE_MESSAGE = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"Usage: extractmarker [options] <input-files>", (Object)" where <input-files> are dex files", (Object)"  --version               # Print the version of r8.", (Object)"  --help                  # Print this message."));

        public static Builder builder() {
            return new Builder();
        }

        public static Builder parse(String[] args) throws CompilationException, IOException {
            Builder builder = Command.builder();
            Command.parse(args, builder);
            return builder;
        }

        private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    throw new CompilationException("Unknown option: " + arg);
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
        }

        private Command(AndroidApp inputApp) {
            super(inputApp);
        }

        private Command(boolean printHelp) {
            super(printHelp, false);
        }

        @Override
        InternalOptions getInternalOptions() {
            return new InternalOptions();
        }

        public static class Builder
        extends BaseCommand.Builder<Command, Builder> {
            @Override
            Builder self() {
                return this;
            }

            @Override
            public Command build() throws CompilationException, IOException {
                if (this.isPrintHelp()) {
                    return new Command(this.isPrintHelp());
                }
                this.validate();
                return new Command(this.getAppBuilder().build());
            }
        }
    }
}

