/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.SwitchPayload;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class PackedSwitchPayload
extends SwitchPayload {
    public final int size;
    public final int first_key;
    public final int[] targets;

    public PackedSwitchPayload(int high, BytecodeStream stream) {
        super(high, stream);
        this.size = PackedSwitchPayload.read16BitValue(stream);
        this.first_key = PackedSwitchPayload.readSigned32BitValue(stream);
        this.targets = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.targets[i] = PackedSwitchPayload.readSigned32BitValue(stream);
        }
    }

    public PackedSwitchPayload(int first_key, int[] targets) {
        assert (targets.length > 0);
        this.size = targets.length;
        this.first_key = first_key;
        this.targets = targets;
    }

    @Override
    public boolean isPayload() {
        return true;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(1, dest);
        this.write16BitValue(this.size, dest);
        this.write32BitValue(this.first_key, dest);
        for (int i = 0; i < this.size; ++i) {
            this.write32BitValue(this.targets[i], dest);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        PackedSwitchPayload that = (PackedSwitchPayload)other;
        return this.size == that.size && this.first_key == that.first_key && Arrays.equals(this.targets, that.targets);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.size;
        result = 31 * result + this.first_key;
        result = 31 * result + Arrays.hashCode(this.targets);
        return result;
    }

    @Override
    public int getSize() {
        return 4 + 2 * this.targets.length;
    }

    @Override
    public int numberOfKeys() {
        return this.size;
    }

    @Override
    public int[] switchTargetOffsets() {
        return this.targets;
    }

    @Override
    public int[] keys() {
        return new int[]{this.first_key};
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder("[PackedSwitchPayload]\n");
        for (int i = 0; i < this.size; ++i) {
            StringUtils.appendLeftPadded(builder, this.first_key + i + " -> " + this.targets[i] + "\n", 20);
        }
        return super.toString(naming) + builder.toString();
    }

    @Override
    public String toSmaliString(Instruction payloadUser) {
        StringBuilder builder = new StringBuilder();
        builder.append("    ");
        builder.append(".packed-switch ");
        builder.append(StringUtils.hexString(this.first_key, 8));
        builder.append("  # ");
        builder.append(this.first_key);
        builder.append("\n");
        for (int target : this.targets) {
            builder.append("      :label_");
            builder.append(payloadUser.getOffset() + target);
            builder.append("\n");
        }
        builder.append("    ");
        builder.append(".end packed-switch");
        return builder.toString();
    }
}

