/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ShaderProcessor
implements DirectoryWalker.FileAction {
    public static final String EXT_VERT = "vert";
    public static final String EXT_TESC = "tesc";
    public static final String EXT_TESE = "tese";
    public static final String EXT_GEOM = "geom";
    public static final String EXT_FRAG = "frag";
    public static final String EXT_COMP = "comp";
    private File mNdkLocation;
    private File mSourceFolder;
    private final File mOutputDir;
    private List<String> mDefaultArgs;
    private Map<String, List<String>> mScopedArgs;
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;
    private final WaitableExecutor mExecutor;
    private File mGlslcLocation;

    public ShaderProcessor(File ndkLocation, File sourceFolder, File outputDir, List<String> defaultArgs, Map<String, List<String>> scopedArgs, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, WaitableExecutor executor) {
        this.mNdkLocation = ndkLocation;
        this.mSourceFolder = sourceFolder;
        this.mOutputDir = new File(outputDir, "shaders");
        this.mDefaultArgs = defaultArgs;
        this.mScopedArgs = scopedArgs;
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
        this.mExecutor = executor;
        this.init();
    }

    public void init() {
        if (this.mNdkLocation == null) {
            throw new IllegalStateException("NDK location is missing. It is required to compile shaders.");
        }
        if (!this.mNdkLocation.isDirectory()) {
            throw new IllegalStateException("NDK location does not exist. It is required to compile shaders: " + this.mNdkLocation);
        }
        File glslcRootFolder = new File(this.mNdkLocation, "shader-tools");
        switch (SdkConstants.currentPlatform()) {
            case 3: {
                glslcRootFolder = new File(glslcRootFolder, "darwin-x86_64");
                break;
            }
            case 2: {
                glslcRootFolder = new File(glslcRootFolder, "windows-x86_64");
                if (glslcRootFolder.isDirectory()) break;
                glslcRootFolder = new File(glslcRootFolder, "windows");
                break;
            }
            case 1: {
                glslcRootFolder = new File(glslcRootFolder, "linux-x86_64");
            }
        }
        if (!glslcRootFolder.isDirectory()) {
            throw new IllegalStateException("Missing NDK subfolder: " + glslcRootFolder);
        }
        this.mGlslcLocation = new File(glslcRootFolder, SdkConstants.FN_GLSLC);
        if (!this.mGlslcLocation.isFile()) {
            throw new IllegalStateException("glslc is missing: " + this.mGlslcLocation);
        }
    }

    @Override
    public void call(Path start, Path path) throws IOException {
        Callable<Object> c = () -> {
            ProcessInfoBuilder builder = new ProcessInfoBuilder();
            builder.setExecutable(this.mGlslcLocation);
            builder.addArgs("-I", this.mSourceFolder.getPath());
            String relativePath = FileUtils.relativePath((File)path.toFile(), (File)start.toFile());
            File destFile = new File(this.mOutputDir, relativePath + ".spv");
            builder.addArgs(this.getArgs(relativePath));
            builder.addArgs(path.toString());
            builder.addArgs("-o", destFile.getPath());
            FileUtils.mkdirs((File)destFile.getParentFile());
            ProcessResult result = this.mProcessExecutor.execute(builder.createProcess(), this.mProcessOutputHandler);
            try {
                result.rethrowFailure().assertNormalExitValue();
            }
            catch (ProcessException pe) {
                throw new IOException(pe);
            }
            return null;
        };
        if (this.mExecutor != null) {
            this.mExecutor.execute(c);
        } else {
            try {
                c.call();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private List<String> getArgs(String relativePath) {
        int pos = relativePath.indexOf(File.separatorChar);
        if (pos == -1) {
            return this.mDefaultArgs;
        }
        String key = relativePath.substring(0, pos);
        List<String> args = this.mScopedArgs.get(key);
        if (args != null) {
            return args;
        }
        return this.mDefaultArgs;
    }
}

