/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatdx;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.D8Output;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.compatdx.CompatDxCommandBuilder;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.joptsimple.OptionParser;
import com.android.tools.r8.joptsimple.OptionSet;
import com.android.tools.r8.joptsimple.OptionSpec;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CompatDx {
    private static final String USAGE_HEADER = "Usage: compatdx [options] <input files>";

    public static void main(String[] args) throws IOException {
        try {
            CompatDx.run(args);
        }
        catch (CompilationException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (DxCompatOptions.DxUsageMessage e) {
            System.err.println(USAGE_HEADER);
            e.printHelpOn(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws DxCompatOptions.DxUsageMessage, IOException, CompilationException {
        D8Output result;
        System.out.println("CompatDx " + String.join((CharSequence)" ", args));
        DxCompatOptions dexArgs = DxCompatOptions.parse(args);
        if (dexArgs.help) {
            CompatDx.printHelpOn(System.out);
            return;
        }
        CompilationMode mode = CompilationMode.RELEASE;
        Path output = null;
        ArrayList<Path> inputs = new ArrayList<Path>();
        boolean singleDexFile = !dexArgs.multiDex;
        Path mainDexList = null;
        int numberOfThreads = 1;
        for (String path : dexArgs.inputs) {
            CompatDx.processPath(new File(path), inputs);
        }
        if (inputs.isEmpty()) {
            if (dexArgs.noFiles) {
                return;
            }
            throw new DxCompatOptions.DxUsageMessage("No input files specified");
        }
        if (!dexArgs.noWarning || dexArgs.debug || dexArgs.verbose) {
            System.out.println("Warning: logging is not enabled for this build.");
        }
        if (dexArgs.dump) {
            System.out.println("Warning: dump is not supported");
        }
        if (dexArgs.verboseDump) {
            throw new Unimplemented("verbose dump file not yet supported");
        }
        if (dexArgs.dumpMethod != null) {
            throw new Unimplemented("method-dump not yet supported");
        }
        if (dexArgs.output != null) {
            output = Paths.get(dexArgs.output, new String[0]);
            if (FileUtils.isDexFile(output)) {
                if (!singleDexFile) {
                    throw new DxCompatOptions.DxUsageMessage("Cannot output to a single dex-file when running with multidex");
                }
            } else if (!(FileUtils.isArchive(output) || output.toFile().exists() && output.toFile().isDirectory())) {
                throw new DxCompatOptions.DxUsageMessage("Unsupported output file or output directory does not exist. Output must be a directory or a file of type dex, apk, jar or zip.");
            }
        }
        if (dexArgs.dumpTo != null) {
            System.out.println("dump-to file not yet supported");
        }
        if (dexArgs.positions == DxCompatOptions.PositionInfo.NONE) {
            System.out.println("Warning: no support for positions none.");
        }
        if (dexArgs.positions == DxCompatOptions.PositionInfo.LINES && !dexArgs.noLocals) {
            mode = CompilationMode.DEBUG;
        }
        if (dexArgs.incremental) {
            throw new Unimplemented("incremental merge not supported yet");
        }
        if (dexArgs.forceJumbo) {
            System.out.println("Warning: no support for forcing jumbo-strings.\nStrings will only use jumbo-string indexing if necessary.\nMake sure that any dex merger subsequently used supports correct handling of jumbo-strings (eg, D8/R8 does).");
        }
        if (dexArgs.noOptimize) {
            System.out.println("Warning: no support for not optimizing");
        }
        if (dexArgs.optimizeList != null) {
            throw new Unimplemented("no support for optimize-method list");
        }
        if (dexArgs.noOptimizeList != null) {
            throw new Unimplemented("no support for dont-optimize-method list");
        }
        if (dexArgs.statistics) {
            System.out.println("Warning: no support for printing statistics");
        }
        if (dexArgs.numThreads > 1) {
            numberOfThreads = dexArgs.numThreads;
        }
        if (dexArgs.mainDexList != null) {
            mainDexList = Paths.get(dexArgs.mainDexList, new String[0]);
        }
        if (dexArgs.noStrict) {
            System.out.println("Warning: conservative main-dex list not yet supported");
        } else {
            System.out.println("Warning: strict name checking not yet supported");
        }
        if (dexArgs.minimalMainDex) {
            System.out.println("Warning: minimal main-dex support is not yet supported");
        }
        if (dexArgs.maxIndexNumber != 0) {
            System.out.println("Warning: internal maximum-index setting is not supported");
        }
        if (numberOfThreads < 1) {
            throw new DxCompatOptions.DxUsageMessage("Invalid numThreads value of " + numberOfThreads);
        }
        ExecutorService executor = ThreadUtils.getExecutorService(numberOfThreads);
        try {
            CompatDxCommandBuilder builder = new CompatDxCommandBuilder();
            ((D8Command.Builder)((D8Command.Builder)builder.addProgramFiles(inputs)).setMode(mode)).setMinApiLevel(dexArgs.minApiLevel);
            if (mainDexList != null) {
                builder.addMainDexListFiles(mainDexList);
            }
            result = D8.run(builder.build());
        }
        finally {
            executor.shutdown();
        }
        if (output == null) {
            return;
        }
        if (singleDexFile) {
            if (result.getDexResources().size() > 1) {
                throw new CompilationError("Compilation result could not fit into a single dex file. Reduce the input-program size or run with --multi-dex enabled");
            }
            if (FileUtils.isDexFile(output)) {
                try (InputStream stream = ((Resource)result.getDexResources().get(0)).getStream();){
                    Files.copy(stream, output, StandardCopyOption.REPLACE_EXISTING);
                }
                return;
            }
        }
        if (dexArgs.keepClasses) {
            if (!FileUtils.isArchive(output)) {
                throw new DxCompatOptions.DxUsageMessage("Output must be an archive when --keep-classes is set.");
            }
            CompatDx.writeZipWithClasses(inputs, result, output);
        } else {
            result.write(output);
        }
    }

    static void printHelpOn(PrintStream sink) throws IOException {
        sink.println(USAGE_HEADER);
        new DxCompatOptions.Spec().parser.printHelpOn(sink);
    }

    private static void processPath(File file, List<Path> files) {
        if (!file.exists()) {
            throw new CompilationError("File does not exist: " + file);
        }
        if (file.isDirectory()) {
            CompatDx.processDirectory(file, files);
            return;
        }
        Path path = file.toPath();
        if (FileUtils.isZipFile(path) || FileUtils.isJarFile(path) || FileUtils.isClassFile(path)) {
            files.add(path);
            return;
        }
        if (FileUtils.isApkFile(path)) {
            throw new Unimplemented("apk files not yet supported");
        }
    }

    private static void processDirectory(File directory, List<Path> files) {
        assert (directory.exists());
        for (File file : directory.listFiles()) {
            CompatDx.processPath(file, files);
        }
    }

    private static void writeZipWithClasses(List<Path> inputs, D8Output output, Path path) throws IOException {
        try (Closer closer = Closer.create();
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            for (Path input : inputs) {
                if (!FileUtils.isArchive(input)) continue;
                ZipFile zipFile = new ZipFile(input.toFile());
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!FileUtils.isClassFile(Paths.get(entry.getName(), new String[0]))) continue;
                        InputStream entryStream = zipFile.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            CompatDx.addEntry(entry.getName(), entryStream, out);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (entryStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    entryStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            entryStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            List dexProgramSources = output.getDexResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                CompatDx.addEntry(CompatDx.getDexFileName(i), closer.register(((Resource)dexProgramSources.get(i)).getStream()), out);
            }
        }
    }

    private static void addEntry(String name, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        byte[] bytes = ByteStreams.toByteArray(in);
        zipEntry.setSize(bytes.length);
        out.putNextEntry(zipEntry);
        out.write(bytes);
        out.closeEntry();
    }

    private static String getDexFileName(int index) {
        return index == 0 ? "classes.dex" : "classes" + (index + 1) + ".dex";
    }

    public static class DxCompatOptions {
        public final boolean help;
        public final boolean debug;
        public final boolean verbose;
        public final PositionInfo positions;
        public final boolean noLocals;
        public final boolean noOptimize;
        public final boolean statistics;
        public final String optimizeList;
        public final String noOptimizeList;
        public final boolean noStrict;
        public final boolean keepClasses;
        public final String output;
        public final String dumpTo;
        public final int dumpWidth;
        public final String dumpMethod;
        public final boolean verboseDump;
        public final boolean dump;
        public final boolean noFiles;
        public final boolean coreLibrary;
        public final int numThreads;
        public final boolean incremental;
        public final boolean forceJumbo;
        public final boolean noWarning;
        public final boolean multiDex;
        public final String mainDexList;
        public final boolean minimalMainDex;
        public final int minApiLevel;
        public final String inputList;
        public final ImmutableList<String> inputs;
        public final int maxIndexNumber;
        private static final String FILE_ARG = "file";
        private static final String NUM_ARG = "number";
        private static final String METHOD_ARG = "method";

        private DxCompatOptions(OptionSet options, Spec spec) {
            this.help = options.has(spec.help);
            this.debug = options.has(spec.debug);
            this.verbose = options.has(spec.verbose);
            if (options.has(spec.positions)) {
                switch (options.valueOf(spec.positions)) {
                    case "none": {
                        this.positions = PositionInfo.NONE;
                        break;
                    }
                    case "important": {
                        this.positions = PositionInfo.IMPORTANT;
                        break;
                    }
                    case "lines": {
                        this.positions = PositionInfo.LINES;
                        break;
                    }
                    default: {
                        this.positions = PositionInfo.IMPORTANT;
                        break;
                    }
                }
            } else {
                this.positions = PositionInfo.LINES;
            }
            this.noLocals = options.has(spec.noLocals);
            this.noOptimize = options.has(spec.noOptimize);
            this.statistics = options.has(spec.statistics);
            this.optimizeList = options.valueOf(spec.optimizeList);
            this.noOptimizeList = options.valueOf(spec.noOptimizeList);
            this.noStrict = options.has(spec.noStrict);
            this.keepClasses = options.has(spec.keepClasses);
            this.output = options.valueOf(spec.output);
            this.dumpTo = options.valueOf(spec.dumpTo);
            this.dumpWidth = options.valueOf(spec.dumpWidth);
            this.dumpMethod = options.valueOf(spec.dumpMethod);
            this.dump = options.has(spec.dump);
            this.verboseDump = options.has(spec.verboseDump);
            this.noFiles = options.has(spec.noFiles);
            this.coreLibrary = options.has(spec.coreLibrary);
            this.numThreads = DxCompatOptions.lastIntOf(options.valuesOf(spec.numThreads));
            this.incremental = options.has(spec.incremental);
            this.forceJumbo = options.has(spec.forceJumbo);
            this.noWarning = options.has(spec.noWarning);
            this.multiDex = options.has(spec.multiDex);
            this.mainDexList = options.valueOf(spec.mainDexList);
            this.minimalMainDex = options.has(spec.minimalMainDex);
            if (options.has(spec.minApiLevel)) {
                List<Integer> allMinApiLevels = options.valuesOf(spec.minApiLevel);
                this.minApiLevel = allMinApiLevels.get(allMinApiLevels.size() - 1);
            } else {
                this.minApiLevel = AndroidApiLevel.getDefault().getLevel();
            }
            this.inputList = options.valueOf(spec.inputList);
            this.inputs = ImmutableList.copyOf(options.valuesOf(spec.inputs));
            this.maxIndexNumber = options.valueOf(spec.maxIndexNumber);
        }

        public static DxCompatOptions parse(String[] args) throws DxParseError {
            Spec spec = new Spec();
            return new DxCompatOptions(spec.parser.parse(args), spec);
        }

        private static int lastIntOf(List<Integer> values) {
            assert (!values.isEmpty());
            return values.get(values.size() - 1);
        }

        private static class Spec {
            final OptionParser parser = new OptionParser();
            final OptionSpec<Void> debug;
            final OptionSpec<Void> verbose;
            final OptionSpec<String> positions;
            final OptionSpec<Void> noLocals;
            final OptionSpec<Void> noOptimize;
            final OptionSpec<Void> statistics;
            final OptionSpec<String> optimizeList;
            final OptionSpec<String> noOptimizeList;
            final OptionSpec<Void> noStrict;
            final OptionSpec<Void> keepClasses;
            final OptionSpec<String> output;
            final OptionSpec<String> dumpTo;
            final OptionSpec<Integer> dumpWidth;
            final OptionSpec<String> dumpMethod;
            final OptionSpec<Void> dump;
            final OptionSpec<Void> verboseDump;
            final OptionSpec<Void> noFiles;
            final OptionSpec<Void> coreLibrary;
            final OptionSpec<Integer> numThreads;
            final OptionSpec<Void> incremental;
            final OptionSpec<Void> forceJumbo;
            final OptionSpec<Void> noWarning;
            final OptionSpec<Void> multiDex;
            final OptionSpec<String> mainDexList;
            final OptionSpec<Void> minimalMainDex;
            final OptionSpec<Integer> minApiLevel;
            final OptionSpec<String> inputList;
            final OptionSpec<String> inputs;
            final OptionSpec<Void> help;
            final OptionSpec<Integer> maxIndexNumber;

            Spec() {
                this.parser.accepts("dex");
                this.debug = this.parser.accepts("debug", "Print debug information");
                this.verbose = this.parser.accepts("verbose", "Print verbose information");
                this.positions = this.parser.accepts("positions", "What source-position information to keep. One of: none, lines, important").withOptionalArg().describedAs("keep").defaultsTo("lines", (String[])new String[0]);
                this.noLocals = this.parser.accepts("no-locals", "Don't keep local variable information");
                this.statistics = this.parser.accepts("statistics", "Print statistics information");
                this.noOptimize = this.parser.accepts("no-optimize", "Don't optimize");
                this.optimizeList = this.parser.accepts("optimize-list", "File listing methods to optimize").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.noOptimizeList = this.parser.accepts("no-optimize-list", "File listing methods not to optimize").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.noStrict = this.parser.accepts("no-strict", "Disable strict file/class name checks");
                this.keepClasses = this.parser.accepts("keep-classes", "Keep input class files in in output jar");
                this.output = this.parser.accepts("output", "Output file or directory").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.dumpTo = this.parser.accepts("dump-to", "File to dump information to").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.dumpWidth = this.parser.accepts("dump-width", "Max width for columns in dump output").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]).describedAs(DxCompatOptions.NUM_ARG);
                this.dumpMethod = this.parser.accepts("dump-method", "Method to dump information for").withRequiredArg().describedAs(DxCompatOptions.METHOD_ARG);
                this.dump = this.parser.accepts("dump", "Dump information");
                this.verboseDump = this.parser.accepts("verbose-dump", "Dump verbose information");
                this.noFiles = this.parser.accepts("no-files", "Don't fail if given no files");
                this.coreLibrary = this.parser.accepts("core-library", "Construct a core library");
                this.numThreads = this.parser.accepts("num-threads", "Number of threads to run with").withRequiredArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]).describedAs(DxCompatOptions.NUM_ARG);
                this.incremental = this.parser.accepts("incremental", "Merge result with the output if it exists");
                this.forceJumbo = this.parser.accepts("force-jumbo", "Force use of string-jumbo instructions");
                this.noWarning = this.parser.accepts("no-warning", "Suppress warnings");
                this.maxIndexNumber = this.parser.accepts("set-max-idx-number", "Undocumented: Set maximal index number to use in a dex file.").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]).describedAs("Maximum index");
                this.minimalMainDex = this.parser.accepts("minimal-main-dex", "Produce smallest possible main dex");
                this.mainDexList = this.parser.accepts("main-dex-list", "File listing classes that must be in the main dex file").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.multiDex = this.parser.accepts("multi-dex", "Allow generation of multi-dex").requiredIf(this.minimalMainDex, this.mainDexList, this.maxIndexNumber);
                this.minApiLevel = this.parser.accepts("min-sdk-version", "Minimum Android API level compatibility.").withRequiredArg().ofType(Integer.class);
                this.inputList = this.parser.accepts("input-list", "File listing input files").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.inputs = this.parser.nonOptions("Input files");
                this.help = this.parser.accepts("help", "Print this message").forHelp();
            }
        }

        private static class DxParseError
        extends DxUsageMessage {
            private final OptionParser parser;

            private DxParseError(OptionParser parser) {
                this.parser = parser;
            }

            @Override
            public void printHelpOn(PrintStream sink) throws IOException {
                this.parser.printHelpOn(sink);
            }
        }

        public static class DxUsageMessage
        extends Exception {
            public final String message;

            public DxUsageMessage() {
                this("");
            }

            DxUsageMessage(String message) {
                this.message = message;
            }

            void printHelpOn(PrintStream sink) throws IOException {
                sink.println(this.message);
            }
        }

        public static enum PositionInfo {
            NONE,
            IMPORTANT,
            LINES;

        }
    }
}

