/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.MinifiedNameMapPrinter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ApplicationWriter {
    public final DexApplication application;
    public final AppInfo appInfo;
    public final byte[] deadCode;
    public final NamingLens namingLens;
    public final byte[] proguardSeedsData;
    public final InternalOptions options;
    public DexString markerString;

    public ApplicationWriter(DexApplication application, AppInfo appInfo, InternalOptions options, Marker marker, byte[] deadCode, NamingLens namingLens, byte[] proguardSeedsData) {
        assert (application != null);
        this.application = application;
        this.appInfo = appInfo;
        assert (options != null);
        this.options = options;
        this.markerString = marker == null ? null : application.dexItemFactory.createString(marker.toString());
        this.deadCode = deadCode;
        this.namingLens = namingLens;
        this.proguardSeedsData = proguardSeedsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidApp write(ExecutorService executorService) throws IOException, ExecutionException, DexOverflowException {
        this.application.timing.begin("DexApplication.write");
        try {
            byte[] byArray;
            byte[] proguardMapResult;
            this.application.dexItemFactory.sort(this.namingLens);
            assert (this.markerString == null || this.application.dexItemFactory.extractMarker() != null);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            VirtualFile.Distributor distributor = null;
            distributor = this.options.outputMode == OutputMode.FilePerInputClass ? new VirtualFile.FilePerInputClassDistributor(this) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty() ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options));
            Map<Integer, VirtualFile> newFiles = ((VirtualFile.Distributor)distributor).run();
            LinkedHashMap<Object, Future<ObjectToOffsetMapping>> offsetMappingFutures = new LinkedHashMap<Object, Future<ObjectToOffsetMapping>>();
            for (int i = 0; i < newFiles.size(); ++i) {
                VirtualFile newFile = newFiles.get(i);
                assert (newFile.getId() == i);
                assert (!newFile.isEmpty());
                if (newFile.isEmpty()) continue;
                offsetMappingFutures.put(newFile, executorService.submit(() -> {
                    ObjectToOffsetMapping mapping = newFile.computeMapping(this.application);
                    ApplicationWriter.rewriteCodeWithJumboStrings(mapping, newFile.classes(), this.application);
                    return mapping;
                }));
            }
            ThreadUtils.awaitFutures(offsetMappingFutures.values());
            LinkedHashMap<Object, Future<byte[]>> dexDataFutures = new LinkedHashMap<Object, Future<byte[]>>();
            for (Object newFile : offsetMappingFutures.keySet()) {
                assert (!((VirtualFile)newFile).isEmpty());
                dexDataFutures.put(newFile, executorService.submit(() -> this.lambda$write$116(offsetMappingFutures, (VirtualFile)newFile)));
            }
            AndroidApp.Builder builder = AndroidApp.builder();
            try {
                for (Map.Entry entry : dexDataFutures.entrySet()) {
                    VirtualFile virtualFile = (VirtualFile)entry.getKey();
                    if (virtualFile.getPrimaryClassDescriptor() != null) {
                        builder.addDexProgramData((byte[])((Future)entry.getValue()).get(), virtualFile.getClassDescriptors(), virtualFile.getPrimaryClassDescriptor());
                        continue;
                    }
                    builder.addDexProgramData((byte[])((Future)entry.getValue()).get(), virtualFile.getClassDescriptors());
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for future.", e);
            }
            if (this.deadCode != null) {
                builder.setDeadCode(this.deadCode);
            }
            if ((proguardMapResult = this.writeProguardMapFile()) != null) {
                builder.setProguardMapData(proguardMapResult);
            }
            if (this.proguardSeedsData != null) {
                builder.setProguardSeedsData(this.proguardSeedsData);
            }
            if ((byArray = this.writeMainDexList()) != null) {
                builder.setMainDexListOutputData(byArray);
            }
            AndroidApp androidApp = builder.build();
            return androidApp;
        }
        finally {
            this.application.timing.end();
        }
    }

    private static void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, List<DexProgramClass> classes, DexApplication application) {
        if (!mapping.hasJumboStrings()) {
            return;
        }
        if (application.highestSortingString != null && application.highestSortingString.slowCompareTo(mapping.getFirstJumboString()) < 0) {
            return;
        }
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(method -> method.rewriteCodeWithJumboStrings(mapping, application));
        }
    }

    private byte[] writeDexFile(ObjectToOffsetMapping mapping) throws ApiLevelException {
        FileWriter fileWriter = new FileWriter(mapping, this.application, this.appInfo, this.options, this.namingLens);
        fileWriter.collect();
        return fileWriter.generate();
    }

    private byte[] writeProguardMapFile() throws IOException {
        if (!this.namingLens.isIdentityLens()) {
            MinifiedNameMapPrinter printer = new MinifiedNameMapPrinter(this.application, this.namingLens);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(bytes);
            printer.write(stream);
            stream.flush();
            return bytes.toByteArray();
        }
        if (this.application.getProguardMap() != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes);
            this.application.getProguardMap().write(writer, !this.options.skipDebugLineNumberOpt);
            ((Writer)writer).flush();
            return bytes.toByteArray();
        }
        return null;
    }

    private String mapMainDexListName(DexType type) {
        return DescriptorUtils.descriptorToJavaType(this.namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private byte[] writeMainDexList() {
        if (this.application.mainDexList.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes);
        this.application.mainDexList.forEach(type -> writer.println(this.mapMainDexListName((DexType)type)));
        writer.flush();
        return bytes.toByteArray();
    }

    private /* synthetic */ byte[] lambda$write$116(Map map, VirtualFile virtualFile) throws Exception {
        return this.writeDexFile((ObjectToOffsetMapping)((Future)map.get(virtualFile)).get());
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(DexAnnotationSetRefList annotationSetRefList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

