/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.dex.BaseFile;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.DexVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DexFile
extends BaseFile {
    final String name;
    private final int version;

    DexFile(String name) throws IOException {
        super(name);
        this.name = name;
        this.version = this.parseMagic(this.buffer);
    }

    public DexFile(InputStream input) throws IOException {
        super(input);
        this.name = "input-stream.dex";
        this.version = this.parseMagic(this.buffer);
    }

    DexFile(byte[] bytes) {
        super(bytes);
        this.name = "mockfile.dex";
        this.version = this.parseMagic(this.buffer);
    }

    private int parseMagic(ByteBuffer buffer) {
        int version;
        int index = 0;
        for (byte prefixByte : Constants.DEX_FILE_MAGIC_PREFIX) {
            if (buffer.get(index++) == prefixByte) continue;
            throw new CompilationError("Dex file has invalid header: " + this.name);
        }
        if (buffer.get(index++) != 48 || buffer.get(index++) != 51) {
            throw new CompilationError("Dex file has invalid version number: " + this.name);
        }
        byte versionByte = buffer.get(index++);
        switch (versionByte) {
            case 57: {
                version = DexVersion.V39.getIntValue();
                break;
            }
            case 56: {
                version = DexVersion.V38.getIntValue();
                break;
            }
            case 55: {
                version = DexVersion.V37.getIntValue();
                break;
            }
            case 53: {
                version = DexVersion.V35.getIntValue();
                break;
            }
            default: {
                throw new CompilationError("Dex file has invalid version number: " + this.name);
            }
        }
        if (buffer.get(index++) != 0) {
            throw new CompilationError("Dex file has invalid header: " + this.name);
        }
        return version;
    }

    @Override
    void setByteOrder() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int endian = this.buffer.getInt(40);
        if (endian == 2018915346) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (endian != 305419896) {
            throw new CompilationError("Unable to determine endianess for reading dex file.");
        }
    }

    int getDexVersion() {
        return this.version;
    }
}

