/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class GraphLense {
    public static Builder builder() {
        return new Builder();
    }

    public abstract DexType lookupType(DexType var1, DexEncodedMethod var2);

    public abstract DexMethod lookupMethod(DexMethod var1, DexEncodedMethod var2);

    public abstract DexField lookupField(DexField var1, DexEncodedMethod var2);

    public abstract boolean isContextFree();

    public static GraphLense getIdentityLense() {
        return new IdentityGraphLense();
    }

    public final boolean isIdentityLense() {
        return this instanceof IdentityGraphLense;
    }

    private static class NestedGraphLense
    extends GraphLense {
        private final GraphLense previousLense;
        private final DexItemFactory dexItemFactory;
        private final Map<DexType, DexType> typeMap;
        private final Map<DexType, DexType> arrayTypeCache = new IdentityHashMap<DexType, DexType>();
        private final Map<DexMethod, DexMethod> methodMap;
        private final Map<DexField, DexField> fieldMap;

        private NestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, GraphLense previousLense, DexItemFactory dexItemFactory) {
            this.typeMap = typeMap;
            this.methodMap = methodMap;
            this.fieldMap = fieldMap;
            this.previousLense = previousLense;
            this.dexItemFactory = dexItemFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DexType lookupType(DexType type, DexEncodedMethod context) {
            if (type.isArrayType()) {
                NestedGraphLense nestedGraphLense = this;
                synchronized (nestedGraphLense) {
                    DexType result = this.arrayTypeCache.get(type);
                    if (result == null) {
                        DexType newType;
                        DexType baseType = type.toBaseType(this.dexItemFactory);
                        result = baseType == (newType = this.lookupType(baseType, context)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                        this.arrayTypeCache.put(type, result);
                    }
                    return result;
                }
            }
            DexType previous = this.previousLense.lookupType(type, context);
            return this.typeMap.getOrDefault(previous, previous);
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context) {
            DexMethod previous = this.previousLense.lookupMethod(method, context);
            return this.methodMap.getOrDefault(previous, previous);
        }

        @Override
        public DexField lookupField(DexField field, DexEncodedMethod context) {
            DexField previous = this.previousLense.lookupField(field, context);
            return this.fieldMap.getOrDefault(previous, previous);
        }

        @Override
        public boolean isContextFree() {
            return this.previousLense.isContextFree();
        }
    }

    private static class IdentityGraphLense
    extends GraphLense {
        private IdentityGraphLense() {
        }

        @Override
        public DexType lookupType(DexType type, DexEncodedMethod context) {
            return type;
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context) {
            return method;
        }

        @Override
        public DexField lookupField(DexField field, DexEncodedMethod context) {
            return field;
        }

        @Override
        public boolean isContextFree() {
            return true;
        }
    }

    public static class Builder {
        private final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        private final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        private final Map<DexField, DexField> fieldMap = new IdentityHashMap<DexField, DexField>();

        private Builder() {
        }

        public void map(DexType from, DexType to) {
            this.typeMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMap.put(from, to);
        }

        public void map(DexField from, DexField to) {
            this.fieldMap.put(from, to);
        }

        public GraphLense build(DexItemFactory dexItemFactory) {
            return this.build(new IdentityGraphLense(), dexItemFactory);
        }

        public GraphLense build(GraphLense previousLense, DexItemFactory dexItemFactory) {
            return new NestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, previousLense, dexItemFactory);
        }
    }
}

