/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public abstract class ArithmeticBinop
extends Binop {
    public ArithmeticBinop(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    public abstract com.android.tools.r8.code.Instruction CreateInt(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateLong(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateFloat(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateDouble(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateInt2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateLong2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateFloat2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateDouble2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit8(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit16(int var1, int var2, int var3);

    @Override
    public boolean canBeFolded() {
        return (this.type == NumericType.INT || this.type == NumericType.LONG || this.type == NumericType.FLOAT || this.type == NumericType.DOUBLE) && this.leftValue().isConstant() && this.rightValue().isConstant();
    }

    @Override
    public boolean needsValueInRegister(Value value) {
        assert (!this.isSub());
        if (value == this.leftValue()) {
            return true;
        }
        assert (value == this.rightValue());
        return !this.fitsInDexInstruction(value);
    }

    @Override
    public ConstInstruction fold(IRCode code) {
        assert (this.canBeFolded());
        if (this.type == NumericType.INT) {
            int left = this.leftValue().getConstInstruction().asConstNumber().getIntValue();
            int right = this.rightValue().getConstInstruction().asConstNumber().getIntValue();
            int result = this.foldIntegers(left, right);
            Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
            return new ConstNumber(ConstType.INT, value, result);
        }
        if (this.type == NumericType.LONG) {
            long left = this.leftValue().getConstInstruction().asConstNumber().getLongValue();
            long right = this.rightValue().getConstInstruction().asConstNumber().getLongValue();
            long result = this.foldLongs(left, right);
            Value value = code.createValue(MoveType.WIDE, this.getLocalInfo());
            return new ConstNumber(ConstType.LONG, value, result);
        }
        if (this.type == NumericType.FLOAT) {
            float left = this.leftValue().getConstInstruction().asConstNumber().getFloatValue();
            float right = this.rightValue().getConstInstruction().asConstNumber().getFloatValue();
            float result = this.foldFloat(left, right);
            Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
            return new ConstNumber(ConstType.FLOAT, value, Float.floatToIntBits(result));
        }
        assert (this.type == NumericType.DOUBLE);
        double left = this.leftValue().getConstInstruction().asConstNumber().getDoubleValue();
        double right = this.rightValue().getConstInstruction().asConstNumber().getDoubleValue();
        double result = this.foldDouble(left, right);
        Value value = code.createValue(MoveType.WIDE, this.getLocalInfo());
        return new ConstNumber(ConstType.DOUBLE, value, Double.doubleToLongBits(result));
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
        int dest = builder.allocatedRegister(this.outValue, this.getNumber());
        com.android.tools.r8.code.Instruction instruction = null;
        if (this.isTwoAddr(builder)) {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            if (left != dest) {
                assert (this.isCommutative());
                assert (right == dest);
                right = left;
            }
            switch (this.type) {
                case DOUBLE: {
                    instruction = this.CreateDouble2Addr(dest, right);
                    break;
                }
                case FLOAT: {
                    instruction = this.CreateFloat2Addr(dest, right);
                    break;
                }
                case INT: {
                    instruction = this.CreateInt2Addr(dest, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong2Addr(dest, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected numeric type " + this.type.name());
                }
            }
        } else if (!this.rightValue().needsRegister()) {
            assert (!this.isSub());
            assert (this.fitsInDexInstruction(this.rightValue()));
            ConstNumber right = this.rightValue().getConstInstruction().asConstNumber();
            if (right.is8Bit()) {
                instruction = this.CreateIntLit8(dest, left, right.getIntValue());
            } else {
                assert (right.is16Bit());
                instruction = this.CreateIntLit16(dest, left, right.getIntValue());
            }
        } else {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            switch (this.type) {
                case DOUBLE: {
                    instruction = this.CreateDouble(dest, left, right);
                    break;
                }
                case FLOAT: {
                    instruction = this.CreateFloat(dest, left, right);
                    break;
                }
                case INT: {
                    instruction = this.CreateInt(dest, left, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong(dest, left, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected numeric type " + this.type.name());
                }
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isArithmeticBinop() {
        return true;
    }

    @Override
    public ArithmeticBinop asArithmeticBinop() {
        return this;
    }
}

