/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MoveType;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public abstract class LogicalBinop
extends Binop {
    public LogicalBinop(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    public abstract com.android.tools.r8.code.Instruction CreateInt(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateLong(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateInt2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateLong2Addr(int var1, int var2);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit8(int var1, int var2, int var3);

    public abstract com.android.tools.r8.code.Instruction CreateIntLit16(int var1, int var2, int var3);

    @Override
    public boolean canBeFolded() {
        return this.leftValue().isConstant() && this.rightValue().isConstant();
    }

    @Override
    public ConstInstruction fold(IRCode code) {
        assert (this.canBeFolded());
        if (this.type == NumericType.INT) {
            int left = this.leftValue().getConstInstruction().asConstNumber().getIntValue();
            int right = this.rightValue().getConstInstruction().asConstNumber().getIntValue();
            int result = this.foldIntegers(left, right);
            Value value = code.createValue(MoveType.SINGLE, this.getLocalInfo());
            return new ConstNumber(ConstType.INT, value, result);
        }
        assert (this.type == NumericType.LONG);
        long left = this.leftValue().getConstInstruction().asConstNumber().getLongValue();
        long right = this.isShl() || this.isShr() || this.isUshr() ? (long)this.rightValue().getConstInstruction().asConstNumber().getIntValue() : this.rightValue().getConstInstruction().asConstNumber().getLongValue();
        long result = this.foldLongs(left, right);
        Value value = code.createValue(MoveType.WIDE, this.getLocalInfo());
        return new ConstNumber(ConstType.LONG, value, result);
    }

    @Override
    public boolean needsValueInRegister(Value value) {
        if (value == this.leftValue()) {
            return true;
        }
        assert (value == this.rightValue());
        return !this.fitsInDexInstruction(value);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        com.android.tools.r8.code.Instruction instruction;
        int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
        int dest = builder.allocatedRegister(this.outValue, this.getNumber());
        if (this.isTwoAddr(builder)) {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            if (left != dest) {
                assert (this.isCommutative());
                assert (right == dest);
                right = left;
            }
            switch (this.type) {
                case INT: {
                    instruction = this.CreateInt2Addr(dest, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong2Addr(dest, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
                }
            }
        } else if (!this.rightValue().needsRegister()) {
            assert (this.fitsInDexInstruction(this.rightValue()));
            ConstNumber right = this.rightValue().getConstInstruction().asConstNumber();
            if (right.is8Bit()) {
                instruction = this.CreateIntLit8(dest, left, right.getIntValue());
            } else {
                assert (right.is16Bit());
                instruction = this.CreateIntLit16(dest, left, right.getIntValue());
            }
        } else {
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            switch (this.type) {
                case INT: {
                    instruction = this.CreateInt(dest, left, right);
                    break;
                }
                case LONG: {
                    instruction = this.CreateLong(dest, left, right);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
                }
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isLogicalBinop() {
        return true;
    }

    @Override
    public LogicalBinop asLogicalBinop() {
        return this;
    }
}

