/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.code.FillArrayData;
import com.android.tools.r8.code.FillArrayDataPayload;
import com.android.tools.r8.code.Format31t;
import com.android.tools.r8.code.Goto16;
import com.android.tools.r8.code.Goto32;
import com.android.tools.r8.code.IfEq;
import com.android.tools.r8.code.IfEqz;
import com.android.tools.r8.code.IfGe;
import com.android.tools.r8.code.IfGez;
import com.android.tools.r8.code.IfGt;
import com.android.tools.r8.code.IfGtz;
import com.android.tools.r8.code.IfLe;
import com.android.tools.r8.code.IfLez;
import com.android.tools.r8.code.IfLt;
import com.android.tools.r8.code.IfLtz;
import com.android.tools.r8.code.IfNe;
import com.android.tools.r8.code.IfNez;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.Move;
import com.android.tools.r8.code.Move16;
import com.android.tools.r8.code.MoveFrom16;
import com.android.tools.r8.code.MoveObject;
import com.android.tools.r8.code.MoveObject16;
import com.android.tools.r8.code.MoveObjectFrom16;
import com.android.tools.r8.code.MoveWide;
import com.android.tools.r8.code.MoveWide16;
import com.android.tools.r8.code.MoveWideFrom16;
import com.android.tools.r8.code.Nop;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NextUntilIterator;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class DexBuilder {
    private final IRCode ir;
    private final RegisterAllocator registerAllocator;
    private final DexItemFactory dexItemFactory;
    private final List<SwitchPayloadInfo> switchPayloadInfos = new ArrayList<SwitchPayloadInfo>();
    private final List<FillArrayDataInfo> fillArrayDataInfos = new ArrayList<FillArrayDataInfo>();
    private Set<BasicBlock> ifsNeedingRewrite = Sets.newIdentityHashSet();
    private int maxOffset = 0;
    private int minOffset = 0;
    private Info[] instructionToInfo;
    private int inRegisterCount = 0;
    private int outRegisterCount = 0;
    private DexString highestSortingReferencedString = null;
    BasicBlock nextBlock;

    public DexBuilder(IRCode ir, RegisterAllocator registerAllocator, DexItemFactory dexItemFactory) {
        assert (ir != null);
        assert (registerAllocator != null);
        assert (dexItemFactory != null);
        this.ir = ir;
        this.registerAllocator = registerAllocator;
        this.dexItemFactory = dexItemFactory;
    }

    private void reset() {
        this.switchPayloadInfos.clear();
        this.fillArrayDataInfos.clear();
        this.ifsNeedingRewrite.clear();
        this.maxOffset = 0;
        this.minOffset = 0;
        this.instructionToInfo = new Info[DexBuilder.instructionNumberToIndex(this.ir.numberRemainingInstructions())];
        this.inRegisterCount = 0;
        this.outRegisterCount = 0;
        this.highestSortingReferencedString = null;
        this.nextBlock = null;
    }

    public DexCode build(int numberOfArguments) {
        int offset;
        int numberOfInstructions;
        do {
            this.rewriteIfs();
            this.reset();
            numberOfInstructions = 0;
            this.removeRedundantDebugPositions();
            ListIterator<BasicBlock> iterator = this.ir.listIterator();
            assert (iterator.hasNext());
            BasicBlock block = iterator.next();
            do {
                this.nextBlock = iterator.hasNext() ? iterator.next() : null;
                block.buildDex(this);
            } while ((block = this.nextBlock) != null);
            offset = 0;
            InstructionIterator it = this.ir.instructionIterator();
            while (it.hasNext()) {
                Info info = this.getInfo((com.android.tools.r8.ir.code.Instruction)it.next());
                info.setOffset(offset);
                offset += info.computeSize(this);
                ++numberOfInstructions;
            }
        } while (!this.ifsNeedingRewrite.isEmpty());
        DexDebugEventBuilder debugEventBuilder = new DexDebugEventBuilder(this.ir.method, this.dexItemFactory);
        ArrayList<Instruction> dexInstructions = new ArrayList<Instruction>(numberOfInstructions);
        int instructionOffset = 0;
        InstructionIterator instructionIterator = this.ir.instructionIterator();
        DexEncodedMethod.DebugPositionRangeList.Builder debugPositionListBuilder = new DexEncodedMethod.DebugPositionRangeList.Builder();
        while (instructionIterator.hasNext()) {
            com.android.tools.r8.ir.code.Instruction ir = (com.android.tools.r8.ir.code.Instruction)instructionIterator.next();
            if (ir.isDebugPosition()) {
                int n = ir.asDebugPosition().line;
                debugPositionListBuilder.add(n, n);
            }
            Info info = this.getInfo(ir);
            int previousInstructionCount = dexInstructions.size();
            info.addInstructions(this, dexInstructions);
            debugEventBuilder.add(instructionOffset, ir);
            if (previousInstructionCount >= dexInstructions.size()) continue;
            while (previousInstructionCount < dexInstructions.size()) {
                Instruction instruction = (Instruction)dexInstructions.get(previousInstructionCount++);
                instruction.setOffset(instructionOffset);
                instructionOffset += instruction.getSize();
            }
        }
        this.ir.method.debugPositionRangeList = debugPositionListBuilder.build();
        for (SwitchPayloadInfo switchPayloadInfo : this.switchPayloadInfos) {
            if (offset % 2 != 0) {
                Nop nop = new Nop();
                nop.setOffset(offset++);
                dexInstructions.add(nop);
            }
            Nop payload = this.createSwitchPayload(switchPayloadInfo, offset);
            payload.setOffset(offset);
            offset += payload.getSize();
            dexInstructions.add(payload);
        }
        for (FillArrayDataInfo fillArrayDataInfo : this.fillArrayDataInfos) {
            if (offset % 2 != 0) {
                Nop nop = new Nop();
                nop.setOffset(offset++);
                dexInstructions.add(nop);
            }
            FillArrayDataPayload payload = fillArrayDataInfo.ir.createPayload();
            payload.setOffset(offset);
            fillArrayDataInfo.dex.setPayloadOffset(offset - fillArrayDataInfo.dex.getOffset());
            offset += payload.getSize();
            dexInstructions.add(payload);
        }
        TryInfo tryInfo = this.computeTryInfo();
        DexCode dexCode = new DexCode(this.registerAllocator.registersUsed(), this.inRegisterCount, this.outRegisterCount, dexInstructions.toArray(new Instruction[dexInstructions.size()]), tryInfo.tries, tryInfo.handlers, debugEventBuilder.build(), this.highestSortingReferencedString);
        return dexCode;
    }

    private void removeRedundantDebugPositions() {
        ListIterator<BasicBlock> iterator = this.ir.listIterator();
        DebugPosition lastMoveExceptionPosition = null;
        while (iterator.hasNext()) {
            BasicBlock next = iterator.next();
            InstructionListIterator it = next.listIterator();
            while (it.hasNext()) {
                com.android.tools.r8.ir.code.Instruction instruction = (com.android.tools.r8.ir.code.Instruction)it.next();
                if (instruction.isDebugPosition()) {
                    if (instruction.asDebugPosition().equals(lastMoveExceptionPosition)) {
                        it.remove();
                    }
                    lastMoveExceptionPosition = null;
                    continue;
                }
                if (!instruction.isMoveException()) continue;
                lastMoveExceptionPosition = instruction.asMoveException().getPosition();
            }
        }
    }

    private void rewriteIfs() {
        if (this.ifsNeedingRewrite.isEmpty()) {
            return;
        }
        ListIterator<BasicBlock> it = this.ir.blocks.listIterator();
        while (it.hasNext()) {
            BasicBlock block = (BasicBlock)it.next();
            if (!this.ifsNeedingRewrite.contains(block)) continue;
            If theIf = block.exit().asIf();
            BasicBlock trueTarget = theIf.getTrueTarget();
            BasicBlock newBlock = BasicBlock.createGotoBlock(trueTarget, this.ir.blocks.size());
            theIf.setTrueTarget(newBlock);
            theIf.invert();
            it.add(newBlock);
        }
    }

    private void needsIfRewriting(BasicBlock block) {
        this.ifsNeedingRewrite.add(block);
    }

    public void registerStringReference(DexString string) {
        if (this.highestSortingReferencedString == null || string.slowCompareTo(this.highestSortingReferencedString) > 0) {
            this.highestSortingReferencedString = string;
        }
    }

    public void requestOutgoingRegisters(int requiredRegisterCount) {
        if (requiredRegisterCount > this.outRegisterCount) {
            this.outRegisterCount = requiredRegisterCount;
        }
    }

    public int allocatedRegister(Value value, int instructionNumber) {
        return this.registerAllocator.getRegisterForValue(value, instructionNumber);
    }

    public int argumentOrAllocateRegister(Value value, int instructionNumber) {
        return this.registerAllocator.getArgumentOrAllocateRegisterForValue(value, instructionNumber);
    }

    public boolean argumentValueUsesHighRegister(Value value, int instructionNumber) {
        return this.registerAllocator.argumentValueUsesHighRegister(value, instructionNumber);
    }

    public void addGoto(Goto jump) {
        if (jump.getTarget() != this.nextBlock) {
            this.add((com.android.tools.r8.ir.code.Instruction)jump, new GotoInfo(jump));
        } else {
            this.addNop(jump);
        }
    }

    public void addIf(If branch) {
        assert (this.nextBlock == branch.fallthroughBlock());
        this.add((com.android.tools.r8.ir.code.Instruction)branch, new IfInfo(branch));
    }

    public void addMove(com.android.tools.r8.ir.code.Move move) {
        this.add((com.android.tools.r8.ir.code.Instruction)move, new MoveInfo(move));
    }

    public void addNop(com.android.tools.r8.ir.code.Instruction instruction) {
        this.add(instruction, new FallThroughInfo(instruction));
    }

    private static boolean isNopInstruction(com.android.tools.r8.ir.code.Instruction instruction) {
        return instruction.isDebugLocalsChange() || instruction.isConstNumber() && !instruction.outValue().needsRegister();
    }

    public void addDebugPosition(DebugPosition position) {
        BasicBlock block = position.getBlock();
        int blockIndex = this.ir.blocks.indexOf(block);
        NextUntilIterator<com.android.tools.r8.ir.code.Instruction> iterator = block.listIterator(position);
        com.android.tools.r8.ir.code.Instruction next = null;
        while (next == null) {
            BasicBlock nextBlock;
            next = (com.android.tools.r8.ir.code.Instruction)iterator.next();
            while (DexBuilder.isNopInstruction(next)) {
                next = (com.android.tools.r8.ir.code.Instruction)iterator.next();
            }
            if (!next.isGoto()) continue;
            BasicBlock basicBlock = nextBlock = ++blockIndex < this.ir.blocks.size() ? this.ir.blocks.get(blockIndex) : null;
            if (next.asGoto().getTarget() != nextBlock) continue;
            iterator = nextBlock.iterator();
            next = null;
        }
        if (next.isDebugPosition() && !position.equals(next.asDebugPosition())) {
            this.add((com.android.tools.r8.ir.code.Instruction)position, new FixedSizeInfo(position, new Nop()));
        } else {
            this.addNop(position);
        }
    }

    public void add(com.android.tools.r8.ir.code.Instruction ir, Instruction dex) {
        assert (!ir.isGoto());
        this.add(ir, new FixedSizeInfo(ir, dex));
    }

    public void add(com.android.tools.r8.ir.code.Instruction ir, Instruction[] dex) {
        assert (!ir.isGoto());
        this.add(ir, new MultiFixedSizeInfo(ir, dex));
    }

    public void addSwitch(Switch s, Format31t dex) {
        assert (this.nextBlock == s.fallthroughBlock());
        this.switchPayloadInfos.add(new SwitchPayloadInfo(s, dex));
        this.add((com.android.tools.r8.ir.code.Instruction)s, dex);
    }

    public void addFillArrayData(NewArrayFilledData nafd, FillArrayData dex) {
        this.fillArrayDataInfos.add(new FillArrayDataInfo(nafd, dex));
        this.add((com.android.tools.r8.ir.code.Instruction)nafd, dex);
    }

    public void addArgument(Argument argument) {
        this.inRegisterCount += argument.outValue().requiredRegisters();
        this.add((com.android.tools.r8.ir.code.Instruction)argument, new FallThroughInfo(argument));
    }

    public void addReturn(Return ret, Instruction dex) {
        if (this.nextBlock != null) {
            Return followingRet = this.nextBlock.exit().asReturn();
            if (this.nextBlock.getInstructions().size() == 1 && followingRet != null && ret.getReturnType() == followingRet.getReturnType()) {
                int otherRegister;
                int thisRegister;
                if (ret.isReturnVoid() && followingRet.isReturnVoid()) {
                    this.addNop(ret);
                    return;
                }
                if (!ret.isReturnVoid() && !followingRet.isReturnVoid() && ret.returnValue().outType() == followingRet.returnValue().outType() && (thisRegister = this.registerAllocator.getRegisterForValue(ret.returnValue(), ret.getNumber())) == (otherRegister = this.registerAllocator.getRegisterForValue(followingRet.returnValue(), followingRet.getNumber()))) {
                    this.addNop(ret);
                    return;
                }
            }
        }
        this.add((com.android.tools.r8.ir.code.Instruction)ret, dex);
    }

    private void add(com.android.tools.r8.ir.code.Instruction ir, Info info) {
        assert (ir != null);
        assert (info != null);
        assert (this.getInfo(ir) == null);
        info.setMinOffset(this.minOffset);
        info.setMaxOffset(this.maxOffset);
        this.minOffset += info.minSize();
        this.maxOffset += info.maxSize();
        this.setInfo(ir, info);
    }

    private static int instructionNumberToIndex(int instructionNumber) {
        return instructionNumber / 2;
    }

    private Info getInfo(com.android.tools.r8.ir.code.Instruction instruction) {
        return this.instructionToInfo[DexBuilder.instructionNumberToIndex(instruction.getNumber())];
    }

    private void setInfo(com.android.tools.r8.ir.code.Instruction instruction, Info info) {
        this.instructionToInfo[DexBuilder.instructionNumberToIndex((int)instruction.getNumber())] = info;
    }

    private Info getTargetInfo(BasicBlock block) {
        InstructionIterator iterator = block.iterator();
        com.android.tools.r8.ir.code.Instruction instruction = null;
        while (iterator.hasNext()) {
            instruction = (com.android.tools.r8.ir.code.Instruction)iterator.next();
            Info info = this.getInfo(instruction);
            if (info instanceof FallThroughInfo) continue;
            return info;
        }
        assert (instruction != null);
        if (instruction.isReturn()) {
            assert (this.getInfo(instruction) instanceof FallThroughInfo);
            return this.getTargetInfo(this.computeNextBlock(block));
        }
        assert (instruction.isGoto());
        return this.getTargetInfo(instruction.asGoto().getTarget());
    }

    private BasicBlock computeNextBlock(BasicBlock block) {
        ListIterator<BasicBlock> it = this.ir.listIterator();
        BasicBlock current = it.next();
        while (current != block) {
            current = it.next();
        }
        return it.next();
    }

    private Nop createSwitchPayload(SwitchPayloadInfo info, int offset) {
        Switch ir = info.ir;
        info.dex.setPayloadOffset(offset - this.getInfo(ir).getOffset());
        int[] targetBlockIndices = ir.targetBlockIndices();
        int[] targets = new int[targetBlockIndices.length];
        for (int i = 0; i < targetBlockIndices.length; ++i) {
            BasicBlock targetBlock = ir.targetBlock(i);
            com.android.tools.r8.ir.code.Instruction targetInstruction = targetBlock.entry();
            targets[i] = this.getInfo(targetInstruction).getOffset() - this.getInfo(ir).getOffset();
        }
        BasicBlock fallthroughBlock = ir.fallthroughBlock();
        com.android.tools.r8.ir.code.Instruction fallthroughTargetInstruction = fallthroughBlock.entry();
        int fallthroughTarget = this.getInfo(fallthroughTargetInstruction).getOffset() - this.getInfo(ir).getOffset();
        return ir.buildPayload(targets, fallthroughTarget);
    }

    private TryInfo computeTryInfo() {
        HashBiMap<CatchHandlers<BasicBlock>, Integer> canonicalHandlers = HashBiMap.create();
        List<TryItem> tryItems = this.computeTryItems(canonicalHandlers);
        DexCode.Try[] tries = DexBuilder.getDexTryItems(tryItems, canonicalHandlers);
        DexCode.TryHandler[] handlers = this.getDexTryHandlers(canonicalHandlers.inverse());
        return new TryInfo(tries, handlers);
    }

    private List<TryItem> computeTryItems(BiMap<CatchHandlers<BasicBlock>, Integer> handlerToIndex) {
        BiMap<Integer, CatchHandlers<BasicBlock>> indexToHandler = handlerToIndex.inverse();
        ArrayList<TryItem> tryItems = new ArrayList<TryItem>();
        ArrayList<BasicBlock> blocksWithHandlers = new ArrayList<BasicBlock>();
        TryItem currentTryItem = null;
        for (BasicBlock block : this.ir.blocks) {
            CatchHandlers handlers = block.getCatchHandlers();
            assert (handlers.isEmpty() || block.canThrow());
            if (!handlers.isEmpty()) {
                if (handlerToIndex.containsKey(handlers)) {
                    handlers = (CatchHandlers)indexToHandler.get(handlerToIndex.get(handlers));
                } else {
                    handlerToIndex.put(handlers, handlerToIndex.size());
                }
                Info startInfo = this.getInfo(block.entry());
                Info endInfo = this.getInfo(block.exit());
                int start = startInfo.getOffset();
                int end = endInfo.getOffset() + endInfo.getSize();
                currentTryItem = new TryItem(handlers, start, end);
                tryItems.add(currentTryItem);
                blocksWithHandlers.add(block);
                continue;
            }
            if (currentTryItem != null && !block.canThrow()) {
                Info endInfo = this.getInfo(block.exit());
                if (endInfo == null) continue;
                currentTryItem.end = endInfo.getOffset() + endInfo.getSize();
                continue;
            }
            currentTryItem = null;
        }
        if (tryItems.isEmpty()) {
            return tryItems;
        }
        tryItems.sort(TryItem::compareTo);
        ArrayList<TryItem> coalescedTryItems = new ArrayList<TryItem>(tryItems.size());
        int i = 0;
        block1: while (i < tryItems.size()) {
            TryItem item = (TryItem)tryItems.get(i);
            coalescedTryItems.add(item);
            LinkedList<com.android.tools.r8.ir.code.Instruction> instructions = ((BasicBlock)blocksWithHandlers.get(i)).getInstructions();
            for (com.android.tools.r8.ir.code.Instruction insn : instructions) {
                if (!insn.instructionTypeCanThrow()) continue;
                item.start = this.getInfo(insn).getOffset();
                break;
            }
            ++i;
            while (i < tryItems.size()) {
                TryItem next = (TryItem)tryItems.get(i);
                if (item.end != next.start || !item.handlers.equals(next.handlers)) {
                    item.end = this.trimEnd((BasicBlock)blocksWithHandlers.get(i - 1));
                    continue block1;
                }
                item.end = next.end;
                ++i;
            }
        }
        int lastIndex = tryItems.size() - 1;
        TryItem lastItem = (TryItem)tryItems.get(lastIndex);
        lastItem.end = this.trimEnd((BasicBlock)blocksWithHandlers.get(lastIndex));
        return coalescedTryItems;
    }

    private int trimEnd(BasicBlock block) {
        LinkedList<com.android.tools.r8.ir.code.Instruction> instructions = block.getInstructions();
        for (com.android.tools.r8.ir.code.Instruction insn : Lists.reverse(instructions)) {
            if (!insn.instructionTypeCanThrow()) continue;
            Info info = this.getInfo(insn);
            return info.getOffset() + info.getSize();
        }
        throw new Unreachable("Expected to find a possibly throwing instruction");
    }

    private static DexCode.Try[] getDexTryItems(List<TryItem> tryItems, Map<CatchHandlers<BasicBlock>, Integer> catchHandlers) {
        DexCode.Try[] tries = new DexCode.Try[tryItems.size()];
        for (int i = 0; i < tries.length; ++i) {
            TryItem item = tryItems.get(i);
            DexCode.Try dexTry = new DexCode.Try(item.start, item.end - item.start, -1);
            dexTry.handlerIndex = catchHandlers.get(item.handlers);
            tries[i] = dexTry;
        }
        return tries;
    }

    private DexCode.TryHandler[] getDexTryHandlers(Map<Integer, CatchHandlers<BasicBlock>> catchHandlers) {
        DexCode.TryHandler[] handlers = new DexCode.TryHandler[catchHandlers.size()];
        for (int j = 0; j < catchHandlers.size(); ++j) {
            CatchHandlers<BasicBlock> handlerGroup = catchHandlers.get(j);
            int catchAllOffset = -1;
            ArrayList<DexCode.TryHandler.TypeAddrPair> pairs = new ArrayList<DexCode.TryHandler.TypeAddrPair>();
            for (int i = 0; i < handlerGroup.getGuards().size(); ++i) {
                DexType type = handlerGroup.getGuards().get(i);
                BasicBlock target = handlerGroup.getAllTargets().get(i);
                int targetOffset = this.getInfo(target.entry()).getOffset();
                if (type == DexItemFactory.catchAllType) {
                    assert (i == handlerGroup.getGuards().size() - 1);
                    catchAllOffset = targetOffset;
                    continue;
                }
                pairs.add(new DexCode.TryHandler.TypeAddrPair(type, targetOffset));
            }
            DexCode.TryHandler.TypeAddrPair[] pairsArray = pairs.toArray(new DexCode.TryHandler.TypeAddrPair[pairs.size()]);
            handlers[j] = new DexCode.TryHandler(pairsArray, catchAllOffset);
        }
        return handlers;
    }

    private static class FillArrayDataInfo {
        public final NewArrayFilledData ir;
        public final FillArrayData dex;

        public FillArrayDataInfo(NewArrayFilledData ir, FillArrayData dex) {
            this.ir = ir;
            this.dex = dex;
        }
    }

    private static class SwitchPayloadInfo {
        public final Switch ir;
        public final Format31t dex;

        public SwitchPayloadInfo(Switch ir, Format31t dex) {
            this.ir = ir;
            this.dex = dex;
        }
    }

    private static class TryItem
    implements Comparable<TryItem> {
        public final CatchHandlers<BasicBlock> handlers;
        public int start;
        public int end;

        public TryItem(CatchHandlers<BasicBlock> handlers, int start, int end) {
            this.handlers = handlers;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(TryItem other) {
            return Integer.compare(this.start, other.start);
        }
    }

    private static class TryInfo {
        public final DexCode.Try[] tries;
        public final DexCode.TryHandler[] handlers;

        public TryInfo(DexCode.Try[] tries, DexCode.TryHandler[] handlers) {
            this.tries = tries;
            this.handlers = handlers;
        }
    }

    public static class MoveInfo
    extends Info {
        private int size = -1;

        public MoveInfo(com.android.tools.r8.ir.code.Move move) {
            super(move);
        }

        private com.android.tools.r8.ir.code.Move getMove() {
            return (com.android.tools.r8.ir.code.Move)this.getIR();
        }

        @Override
        public int computeSize(DexBuilder builder) {
            int destRegister;
            com.android.tools.r8.ir.code.Move move = this.getMove();
            int srcRegister = builder.allocatedRegister(move.src(), move.getNumber());
            this.size = srcRegister == (destRegister = builder.allocatedRegister(move.dest(), move.getNumber())) ? 1 : (srcRegister <= 15 && destRegister <= 15 ? 1 : (destRegister <= 255 ? 2 : 3));
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
            com.android.tools.r8.ir.code.Move move = this.getMove();
            int dest = builder.allocatedRegister(move.dest(), move.getNumber());
            int src = builder.allocatedRegister(move.src(), move.getNumber());
            Instruction instruction = null;
            block0 : switch (this.size) {
                case 1: {
                    if (src == dest) {
                        instruction = new Nop();
                        break;
                    }
                    switch (move.outType()) {
                        case SINGLE: {
                            instruction = new Move(dest, src);
                            break block0;
                        }
                        case WIDE: {
                            instruction = new MoveWide(dest, src);
                            break block0;
                        }
                        case OBJECT: {
                            instruction = new MoveObject(dest, src);
                            break block0;
                        }
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
                case 2: {
                    switch (move.outType()) {
                        case SINGLE: {
                            instruction = new MoveFrom16(dest, src);
                            break block0;
                        }
                        case WIDE: {
                            instruction = new MoveWideFrom16(dest, src);
                            break block0;
                        }
                        case OBJECT: {
                            instruction = new MoveObjectFrom16(dest, src);
                            break block0;
                        }
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
                case 3: {
                    switch (move.outType()) {
                        case SINGLE: {
                            instruction = new Move16(dest, src);
                            break block0;
                        }
                        case WIDE: {
                            instruction = new MoveWide16(dest, src);
                            break block0;
                        }
                        case OBJECT: {
                            instruction = new MoveObject16(dest, src);
                            break block0;
                        }
                    }
                    throw new Unreachable("Unexpected type: " + (Object)((Object)move.outType()));
                }
            }
            instruction.setOffset(this.getOffset());
            instructions.add(instruction);
        }

        @Override
        public int minSize() {
            assert (new Nop().getSize() == 1 && new Move(0, 0).getSize() == 1);
            return 1;
        }

        @Override
        public int maxSize() {
            assert (new Move16(0, 0).getSize() == 3);
            return 3;
        }

        @Override
        public int getSize() {
            assert (this.size > 0);
            return this.size;
        }
    }

    public static class IfInfo
    extends Info {
        private int size = -1;

        public IfInfo(If branch) {
            super(branch);
        }

        private If getBranch() {
            return (If)this.getIR();
        }

        private boolean branchesToSelf(DexBuilder builder) {
            Info trueTargetInfo;
            If branch = this.getBranch();
            return branch == (trueTargetInfo = builder.getTargetInfo(branch.getTrueTarget())).getIR();
        }

        private boolean offsetOutOfRange(DexBuilder builder) {
            Info targetInfo = builder.getTargetInfo(this.getBranch().getTrueTarget());
            int maxOffset = this.getMaxOffset();
            int maxTargetOffset = targetInfo.getMaxOffset();
            if (maxTargetOffset < maxOffset) {
                return this.getOffset() - targetInfo.getOffset() < Short.MIN_VALUE;
            }
            int maxOverEstimation = maxOffset - this.getOffset();
            return maxTargetOffset - maxOverEstimation - this.getOffset() > Short.MAX_VALUE;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
            If branch = this.getBranch();
            int source = builder.getInfo(branch).getOffset();
            int target = builder.getInfo(branch.getTrueTarget().entry()).getOffset();
            int relativeOffset = target - source;
            int register1 = builder.allocatedRegister(branch.inValues().get(0), branch.getNumber());
            if (this.size == 3) {
                assert (this.branchesToSelf(builder));
                Nop nop = new Nop();
                relativeOffset -= nop.getSize();
                instructions.add(nop);
            }
            assert (relativeOffset != 0);
            Instruction instruction = null;
            if (branch.isZeroTest()) {
                switch (this.getBranch().getType()) {
                    case EQ: {
                        instruction = new IfEqz(register1, relativeOffset);
                        break;
                    }
                    case GE: {
                        instruction = new IfGez(register1, relativeOffset);
                        break;
                    }
                    case GT: {
                        instruction = new IfGtz(register1, relativeOffset);
                        break;
                    }
                    case LE: {
                        instruction = new IfLez(register1, relativeOffset);
                        break;
                    }
                    case LT: {
                        instruction = new IfLtz(register1, relativeOffset);
                        break;
                    }
                    case NE: {
                        instruction = new IfNez(register1, relativeOffset);
                    }
                }
            } else {
                int register2 = builder.allocatedRegister(branch.inValues().get(1), branch.getNumber());
                switch (this.getBranch().getType()) {
                    case EQ: {
                        instruction = new IfEq(register1, register2, relativeOffset);
                        break;
                    }
                    case GE: {
                        instruction = new IfGe(register1, register2, relativeOffset);
                        break;
                    }
                    case GT: {
                        instruction = new IfGt(register1, register2, relativeOffset);
                        break;
                    }
                    case LE: {
                        instruction = new IfLe(register1, register2, relativeOffset);
                        break;
                    }
                    case LT: {
                        instruction = new IfLt(register1, register2, relativeOffset);
                        break;
                    }
                    case NE: {
                        instruction = new IfNe(register1, register2, relativeOffset);
                    }
                }
            }
            instruction.setOffset(this.getOffset());
            instructions.add(instruction);
        }

        @Override
        public int computeSize(DexBuilder builder) {
            if (this.offsetOutOfRange(builder)) {
                builder.needsIfRewriting(this.getBranch().getBlock());
            }
            this.size = this.branchesToSelf(builder) ? 3 : 2;
            return this.size;
        }

        @Override
        public int minSize() {
            return 2;
        }

        @Override
        public int maxSize() {
            return 3;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    private static class GotoInfo
    extends Info {
        private int size = -1;

        public GotoInfo(Goto jump) {
            super(jump);
        }

        private Goto getJump() {
            return (Goto)this.getIR();
        }

        @Override
        public int getSize() {
            assert (this.size > 0);
            return this.size;
        }

        @Override
        public int minSize() {
            assert (new com.android.tools.r8.code.Goto(42).getSize() == 1);
            return 1;
        }

        @Override
        public int maxSize() {
            assert (new Goto32(0).getSize() == 3);
            return 3;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            int delta;
            Info targetInfo;
            assert (this.size < 0);
            Goto jump = this.getJump();
            if (jump == (targetInfo = builder.getTargetInfo(jump.getTarget())).getIR()) {
                this.size = 2;
                return this.size;
            }
            int maxOffset = this.getMaxOffset();
            int maxTargetOffset = targetInfo.getMaxOffset();
            if (maxTargetOffset < maxOffset) {
                delta = this.getOffset() - targetInfo.getOffset();
            } else {
                int maxOverEstimation = maxOffset - this.getOffset();
                delta = maxTargetOffset - maxOverEstimation - this.getOffset();
            }
            this.size = delta <= 127 ? 1 : (delta <= Short.MAX_VALUE ? 2 : 3);
            if (targetInfo.getIR().isReturn() && GotoInfo.canTargetReturn(targetInfo.getIR().asReturn())) {
                assert (!(targetInfo instanceof FallThroughInfo));
                this.size = Math.min(targetInfo.getSize(), this.size);
            }
            assert (this.size != 0);
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
            Goto jump = this.getJump();
            int source = builder.getInfo(jump).getOffset();
            Info targetInfo = builder.getTargetInfo(jump.getTarget());
            int relativeOffset = targetInfo.getOffset() - source;
            Return ret = targetInfo.getIR().asReturn();
            if (ret != null && this.size == targetInfo.getSize() && GotoInfo.canTargetReturn(ret)) {
                Instruction dex = ret.createDexInstruction(builder);
                dex.setOffset(this.getOffset());
                instructions.add(dex);
            } else if (this.size == relativeOffset) {
                for (int i = 0; i < this.size; ++i) {
                    Nop dex = new Nop();
                    assert (((Instruction)dex).getSize() == 1);
                    dex.setOffset(this.getOffset() + i);
                    instructions.add(dex);
                }
            } else {
                Instruction dex;
                switch (this.size) {
                    case 1: {
                        assert (relativeOffset != 0);
                        dex = new com.android.tools.r8.code.Goto(relativeOffset);
                        break;
                    }
                    case 2: {
                        if (relativeOffset == 0) {
                            Nop nop = new Nop();
                            instructions.add(nop);
                            dex = new com.android.tools.r8.code.Goto(-nop.getSize());
                            break;
                        }
                        dex = new Goto16(relativeOffset);
                        break;
                    }
                    case 3: {
                        dex = new Goto32(relativeOffset);
                        break;
                    }
                    default: {
                        throw new Unreachable("Unexpected size for goto instruction: " + this.size);
                    }
                }
                dex.setOffset(this.getOffset());
                instructions.add(dex);
            }
        }

        private static boolean canTargetReturn(Return ret) {
            InstructionListIterator it = ret.getBlock().listIterator(ret);
            com.android.tools.r8.ir.code.Instruction prev = (com.android.tools.r8.ir.code.Instruction)it.previous();
            while (it.hasPrevious() && DexBuilder.isNopInstruction(prev = (com.android.tools.r8.ir.code.Instruction)it.previous())) {
            }
            return !prev.isDebugPosition();
        }
    }

    private static class FallThroughInfo
    extends Info {
        public FallThroughInfo(com.android.tools.r8.ir.code.Instruction ir) {
            super(ir);
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            return 0;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
        }

        @Override
        public int minSize() {
            return 0;
        }

        @Override
        public int maxSize() {
            return 0;
        }
    }

    private static class MultiFixedSizeInfo
    extends Info {
        private Instruction[] instructions;
        private final int size;

        public MultiFixedSizeInfo(com.android.tools.r8.ir.code.Instruction ir, Instruction[] instructions) {
            super(ir);
            this.instructions = instructions;
            int size = 0;
            for (Instruction instruction : instructions) {
                size += instruction.getSize();
            }
            this.size = size;
        }

        @Override
        public int computeSize(DexBuilder builder) {
            return this.size;
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
            int offset = this.getOffset();
            for (Instruction instruction : this.instructions) {
                instructions.add(instruction);
                instruction.setOffset(offset);
                offset += instruction.getSize();
            }
        }

        @Override
        public int minSize() {
            return this.size;
        }

        @Override
        public int maxSize() {
            return this.size;
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }

    private static class FixedSizeInfo
    extends Info {
        private Instruction instruction;

        public FixedSizeInfo(com.android.tools.r8.ir.code.Instruction ir, Instruction instruction) {
            super(ir);
            this.instruction = instruction;
        }

        @Override
        public int getSize() {
            return this.instruction.getSize();
        }

        @Override
        public int minSize() {
            return this.instruction.getSize();
        }

        @Override
        public int maxSize() {
            return this.instruction.getSize();
        }

        @Override
        public int computeSize(DexBuilder builder) {
            this.instruction.setOffset(this.getOffset());
            return this.instruction.getSize();
        }

        @Override
        public void addInstructions(DexBuilder builder, List<Instruction> instructions) {
            instructions.add(this.instruction);
        }
    }

    private static abstract class Info {
        private final com.android.tools.r8.ir.code.Instruction ir;
        private int offset = -1;
        private int minOffset = -1;
        private int maxOffset = -1;

        public Info(com.android.tools.r8.ir.code.Instruction ir) {
            assert (ir != null);
            this.ir = ir;
        }

        public abstract int computeSize(DexBuilder var1);

        public abstract void addInstructions(DexBuilder var1, List<Instruction> var2);

        public abstract int minSize();

        public abstract int maxSize();

        public abstract int getSize();

        public int getOffset() {
            assert (this.offset >= 0) : this;
            return this.offset;
        }

        public void setOffset(int offset) {
            assert (offset >= 0);
            this.offset = offset;
        }

        public int getMinOffset() {
            assert (this.minOffset >= 0);
            return this.minOffset;
        }

        public void setMinOffset(int minOffset) {
            assert (minOffset >= 0);
            this.minOffset = minOffset;
        }

        public int getMaxOffset() {
            assert (this.maxOffset >= 0);
            return this.maxOffset;
        }

        public void setMaxOffset(int maxOffset) {
            assert (maxOffset >= 0);
            this.maxOffset = maxOffset;
        }

        public com.android.tools.r8.ir.code.Instruction getIR() {
            return this.ir;
        }
    }
}

