/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexAccessFlags;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Inliner {
    protected final AppInfoWithSubtyping appInfo;
    private final GraphLense graphLense;
    private final InternalOptions options;
    private boolean applyDoubleInlining = false;
    private final Set<DexEncodedMethod> doubleInlineCallers = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> doubleInlineSelectedTargets = Sets.newIdentityHashSet();
    private final Map<DexEncodedMethod, DexEncodedMethod> doubleInlineeCandidates = new HashMap<DexEncodedMethod, DexEncodedMethod>();

    public Inliner(AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options) {
        this.appInfo = appInfo;
        this.graphLense = graphLense;
        this.options = options;
    }

    private Constraint instructionAllowedForInlining(DexEncodedMethod method, Instruction instruction) {
        Constraint result = instruction.inliningConstraint(this.appInfo, method.method.holder);
        if (result == Constraint.NEVER && instruction.isDebugInstruction()) {
            return Constraint.ALWAYS;
        }
        return result;
    }

    public Constraint computeInliningConstraint(IRCode code, DexEncodedMethod method) {
        Constraint result = Constraint.ALWAYS;
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            Constraint state = this.instructionAllowedForInlining(method, instruction);
            if (state == Constraint.NEVER) {
                return Constraint.NEVER;
            }
            if (state.ordinal() >= result.ordinal()) continue;
            result = state;
        }
        return result;
    }

    boolean hasInliningAccess(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.isVisibleWithFlags(target.method.holder, method.method.holder, target.accessFlags)) {
            return false;
        }
        DexClass targetClass = this.appInfo.definitionFor(target.method.holder);
        return this.isVisibleWithFlags(target.method.holder, method.method.holder, targetClass.accessFlags);
    }

    private boolean isVisibleWithFlags(DexType target, DexType context, DexAccessFlags flags) {
        if (flags.isPublic()) {
            return true;
        }
        if (flags.isPrivate()) {
            return target == context;
        }
        if (flags.isProtected()) {
            return context.isSubtypeOf(target, this.appInfo) || target.isSamePackage(context);
        }
        return target.isSamePackage(context);
    }

    synchronized DexEncodedMethod doubleInlining(DexEncodedMethod method, DexEncodedMethod target) {
        if (!this.applyDoubleInlining) {
            if (this.doubleInlineeCandidates.containsKey(target)) {
                this.doubleInlineCallers.add(this.doubleInlineeCandidates.get(target));
                this.doubleInlineCallers.add(method);
                this.doubleInlineSelectedTargets.add(target);
            } else {
                this.doubleInlineeCandidates.put(target, method);
            }
            return null;
        }
        if (!this.doubleInlineSelectedTargets.contains(target)) {
            return null;
        }
        return target;
    }

    public synchronized void processDoubleInlineCallers(IRConverter converter, OptimizationFeedback feedback) throws ApiLevelException {
        if (this.doubleInlineCallers.size() > 0) {
            this.applyDoubleInlining = true;
            List methods = this.doubleInlineCallers.stream().sorted(DexEncodedMethod::slowCompare).collect(Collectors.toList());
            for (DexEncodedMethod method : methods) {
                converter.processMethod(method, feedback, x -> false, CallSiteInformation.empty(), Outliner::noProcessing);
                assert (method.isProcessed());
            }
        }
    }

    private int numberOfInstructions(IRCode code) {
        int numOfInstructions = 0;
        for (BasicBlock block : code.blocks) {
            numOfInstructions += block.getInstructions().size();
        }
        return numOfInstructions;
    }

    private boolean legalConstructorInline(DexEncodedMethod method, InvokeMethod invoke, IRCode code) {
        DexType methodHolder = method.method.holder;
        boolean methodIsConstructor = method.isInstanceInitializer();
        if (methodIsConstructor && methodHolder == invoke.asInvokeMethod().getInvokedMethod().holder) {
            return true;
        }
        boolean receiverOfInnerCallIsThisOfOuter = invoke.asInvokeDirect().getReceiver().isThis();
        InstructionIterator iterator = code.instructionIterator();
        Instruction instruction = (Instruction)iterator.next();
        assert (instruction.isArgument());
        Value unInitializedObject = instruction.outValue();
        boolean seenSuperInvoke = false;
        while (iterator.hasNext()) {
            instruction = (Instruction)iterator.next();
            if (instruction.inValues().contains(unInitializedObject)) {
                if (instruction.isInvokeDirect() && !seenSuperInvoke) {
                    boolean callOnSupertypeOfThisInConstructor;
                    DexMethod target = instruction.asInvokeDirect().getInvokedMethod();
                    seenSuperInvoke = this.appInfo.dexItemFactory.isConstructor(target);
                    boolean bl = callOnSupertypeOfThisInConstructor = methodHolder.isImmediateSubtypeOf(target.holder) && instruction.asInvokeDirect().getReceiver() == unInitializedObject && receiverOfInnerCallIsThisOfOuter && methodIsConstructor;
                    if (seenSuperInvoke && !callOnSupertypeOfThisInConstructor) {
                        return false;
                    }
                }
                if (!seenSuperInvoke) {
                    return false;
                }
            }
            if (!instruction.isInstancePut()) continue;
            if (!methodIsConstructor) {
                return false;
            }
            DexField field = instruction.asInstancePut().getField();
            DexEncodedField target = this.appInfo.lookupInstanceTarget(field.getHolder(), field);
            if (target == null || !target.accessFlags.isFinal()) continue;
            return false;
        }
        return true;
    }

    public void performInlining(DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation) throws ApiLevelException {
        int instruction_allowance = 1500;
        if ((instruction_allowance -= this.numberOfInstructions(code)) < 0) {
            return;
        }
        this.computeReceiverMustBeNonNull(code);
        InliningOracle oracle = new InliningOracle(this, method, callSiteInformation, isProcessedConcurrently);
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext() && instruction_allowance >= 0) {
            BasicBlock block = blockIterator.next();
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext() && instruction_allowance >= 0) {
                InvokeMethod invoke;
                InlineAction result;
                Instruction current = (Instruction)iterator.next();
                if (!current.isInvokeMethod() || (result = (invoke = current.asInvokeMethod()).computeInlining(oracle)) == null) continue;
                DexEncodedMethod target = result.target;
                IRCode inlinee = result.buildIR(code.valueNumberGenerator, this.appInfo, this.graphLense, this.options);
                if (inlinee == null || block.hasCatchHandlers() && inlinee.computeNormalExitBlocks().isEmpty()) continue;
                if (!target.isProcessed()) {
                    assert (result.reason == Reason.FORCE);
                    this.performInlining(target, inlinee, isProcessedConcurrently, callSiteInformation);
                }
                assert (!target.isClassInitializer());
                if (target.isInstanceInitializer() && !this.legalConstructorInline(method, invoke, inlinee)) continue;
                DexType downcast = null;
                if (invoke.isInvokeMethodWithReceiver() && target.method.getHolder() != invoke.getInvokedMethod().getHolder()) {
                    downcast = result.target.method.getHolder();
                }
                iterator.previous();
                if ((instruction_allowance -= this.numberOfInstructions(inlinee)) >= 0 || result.ignoreInstructionBudget()) {
                    iterator.inlineInvoke(code, inlinee, blockIterator, blocksToRemove, downcast);
                }
                if (!method.accessFlags.isBridge()) continue;
                method.accessFlags.unsetSynthetic();
                method.accessFlags.unsetBridge();
            }
        }
        oracle.finish();
        code.removeBlocks(blocksToRemove);
        assert (code.isConsistentSSA());
    }

    private void computeReceiverMustBeNonNull(IRCode code) {
        DominatorTree dominatorTree = new DominatorTree(code);
        InstructionIterator it = code.instructionIterator();
        block0: while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isInvokeMethodWithReceiver()) continue;
            Value receiverValue = instruction.inValues().get(0);
            for (Instruction user : receiverValue.uniqueUsers()) {
                if (!user.isInvokeMethodWithReceiver() || user.inValues().get(0) != receiverValue || user.getBlock().hasCatchHandlers() || !dominatorTree.strictlyDominatedBy(instruction.getBlock(), user.getBlock())) continue;
                instruction.asInvokeMethodWithReceiver().setIsDominatedByCallWithSameReceiver();
                continue block0;
            }
        }
    }

    public static class InlineAction {
        public final DexEncodedMethod target;
        public final Invoke invoke;
        final Reason reason;

        InlineAction(DexEncodedMethod target, Invoke invoke, Reason reason) {
            this.target = target;
            this.invoke = invoke;
            this.reason = reason;
        }

        boolean ignoreInstructionBudget() {
            return this.reason != Reason.SIMPLE;
        }

        public IRCode buildIR(ValueNumberGenerator generator, AppInfoWithSubtyping appInfo, GraphLense graphLense, InternalOptions options) throws ApiLevelException {
            if (this.target.isProcessed()) {
                assert (this.target.getCode().isDexCode());
                return this.target.buildIR(generator, options);
            }
            IRCode code = this.target.getCode().isJarCode() ? this.target.getCode().asJarCode().buildIR(this.target, generator, options) : this.target.getCode().asDexCode().buildIR(this.target, generator, options);
            new LensCodeRewriter(graphLense, appInfo).rewrite(code, this.target);
            return code;
        }
    }

    public static enum Reason {
        FORCE,
        ALWAYS,
        SINGLE_CALLER,
        DUAL_CALLER,
        SIMPLE;

    }

    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint NEVER = new Constraint();
        public static final /* enum */ Constraint SAMECLASS = new Constraint();
        public static final /* enum */ Constraint PACKAGE = new Constraint();
        public static final /* enum */ Constraint SUBCLASS = new Constraint();
        public static final /* enum */ Constraint ALWAYS = new Constraint();
        private static final /* synthetic */ Constraint[] $VALUES;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String name) {
            return Enum.valueOf(Constraint.class, name);
        }

        public static Constraint deriveConstraint(DexType contextHolder, DexType targetHolder, DexAccessFlags flags, AppInfoWithSubtyping appInfo) {
            if (flags.isPublic()) {
                return ALWAYS;
            }
            if (flags.isPrivate()) {
                return targetHolder == contextHolder ? SAMECLASS : NEVER;
            }
            if (flags.isProtected()) {
                if (targetHolder.isSamePackage(contextHolder)) {
                    return PACKAGE;
                }
                if (contextHolder.isSubtypeOf(targetHolder, appInfo)) {
                    return SUBCLASS;
                }
                return NEVER;
            }
            return targetHolder.isSamePackage(contextHolder) ? PACKAGE : NEVER;
        }

        public static Constraint classIsVisible(DexType context, DexType clazz, AppInfoWithSubtyping appInfo) {
            DexClass definition = appInfo.definitionFor(clazz);
            return definition == null ? NEVER : Constraint.deriveConstraint(context, clazz, definition.accessFlags, appInfo);
        }

        public static Constraint min(Constraint one, Constraint other) {
            return one.ordinal() < other.ordinal() ? one : other;
        }

        static {
            $VALUES = new Constraint[]{NEVER, SAMECLASS, PACKAGE, SUBCLASS, ALWAYS};
            assert (NEVER.ordinal() < SAMECLASS.ordinal());
            assert (SAMECLASS.ordinal() < PACKAGE.ordinal());
            assert (PACKAGE.ordinal() < SUBCLASS.ordinal());
            assert (SUBCLASS.ordinal() < ALWAYS.ordinal());
        }
    }
}

