/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.Map;

class FieldNameMinifier
extends MemberNameMinifier<DexField, DexType> {
    FieldNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        super(appInfo, rootSet, options);
    }

    Map<DexField, DexString> computeRenaming(Timing timing) {
        timing.begin("reserve-classes");
        this.reserveNamesInSubtypes(this.appInfo.dexItemFactory.objectType, this.globalState);
        timing.end();
        timing.begin("reserve-interfaces");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInSubtypes((DexType)iface, this.globalState));
        timing.end();
        timing.begin("rename");
        this.renameFieldsInSubtypes(this.appInfo.dexItemFactory.objectType);
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, this::renameFieldsInSubtypes);
        timing.end();
        return this.renaming;
    }

    private void reserveNamesInSubtypes(DexType type, NamingState<DexType> state) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder == null) {
            return;
        }
        NamingState newState = this.computeStateIfAbsent(type, t -> state.createChild());
        holder.forEachField(field -> this.reserveFieldName((DexEncodedField)field, newState, holder.isLibraryClass()));
        type.forAllExtendsSubtypes(subtype -> this.reserveNamesInSubtypes((DexType)subtype, newState));
    }

    private void reserveFieldName(DexEncodedField encodedField, NamingState<DexType> state, boolean isLibrary) {
        if (isLibrary || this.rootSet.noObfuscation.contains(encodedField)) {
            DexField field = encodedField.field;
            state.reserveName(field.name, field.type);
        }
    }

    private void renameFieldsInSubtypes(DexType type) {
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        NamingState state = this.getState(clazz.type);
        assert (state != null);
        clazz.forEachField(field -> this.renameField((DexEncodedField)field, state));
        type.forAllExtendsSubtypes(this::renameFieldsInSubtypes);
    }

    private void renameField(DexEncodedField encodedField, NamingState<DexType> state) {
        DexField field = encodedField.field;
        if (!state.isReserved(field.name, field.type)) {
            this.renaming.put(field, state.assignNewNameFor(field.name, field.type, false));
        }
    }
}

