/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;

public class AnnotationRemover {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final InternalOptions.KeepAttributeOptions keep;

    public AnnotationRemover(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this(appInfo, options.keepAttributes);
    }

    public AnnotationRemover(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions.KeepAttributeOptions keep) {
        this.appInfo = appInfo;
        this.keep = keep;
    }

    private boolean filterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                DexItemFactory factory = this.appInfo.dexItemFactory;
                if (this.keep.innerClasses && (DexAnnotation.isInnerClassesAnnotation(annotation, factory) || DexAnnotation.isEnclosingClassAnnotation(annotation, factory))) {
                    return true;
                }
                if (this.keep.enclosingMethod && DexAnnotation.isEnclosingMethodAnnotation(annotation, factory)) {
                    return true;
                }
                if (this.keep.exceptions && DexAnnotation.isThrowingAnnotation(annotation, factory)) {
                    return true;
                }
                if (this.keep.signature && DexAnnotation.isSignatureAnnotation(annotation, factory)) {
                    return true;
                }
                return this.keep.sourceDebugExtension && DexAnnotation.isSourceDebugExtension(annotation, factory);
            }
            case 1: {
                if (this.keep.runtimeVisibleAnnotations) break;
                return false;
            }
            case 0: {
                if (this.keep.runtimeInvisibleAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visiility.");
            }
        }
        return this.appInfo.liveTypes.contains(annotation.annotation.type);
    }

    private boolean filterParameterAnnotations(DexAnnotation annotation) {
        switch (annotation.visibility) {
            case 2: {
                return false;
            }
            case 1: {
                if (this.keep.runtimeVisibleParameterAnnotations) break;
                return false;
            }
            case 0: {
                if (this.keep.runtimeInvisibleParamterAnnotations) break;
                return false;
            }
            default: {
                throw new Unreachable("Unexpected annotation visibility.");
            }
        }
        return this.appInfo.liveTypes.contains(annotation.annotation.type);
    }

    public void run() {
        this.keep.ensureValid();
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.annotations = this.stripAnnotations(clazz.annotations, this::filterAnnotations);
            clazz.forEachMethod(this::processMethod);
            clazz.forEachField(this::processField);
        }
    }

    private void processMethod(DexEncodedMethod method) {
        method.annotations = this.stripAnnotations(method.annotations, this::filterAnnotations);
        method.parameterAnnotations = this.stripAnnotations(method.parameterAnnotations, this::filterParameterAnnotations);
    }

    private void processField(DexEncodedField field) {
        field.annotations = this.stripAnnotations(field.annotations, this::filterAnnotations);
    }

    private DexAnnotationSetRefList stripAnnotations(DexAnnotationSetRefList annotations, Predicate<DexAnnotation> filter) {
        DexAnnotationSet[] filtered = null;
        for (int i = 0; i < annotations.values.length; ++i) {
            DexAnnotationSet updated = this.stripAnnotations(annotations.values[i], filter);
            if (updated == annotations.values[i] || filtered != null) continue;
            filtered = (DexAnnotationSet[])annotations.values.clone();
            filtered[i] = updated;
        }
        if (filtered == null) {
            return annotations;
        }
        if (Arrays.stream(filtered).allMatch(DexAnnotationSet::isEmpty)) {
            return DexAnnotationSetRefList.empty();
        }
        return new DexAnnotationSetRefList(filtered);
    }

    private DexAnnotationSet stripAnnotations(DexAnnotationSet annotations, Predicate<DexAnnotation> filter) {
        ArrayList<DexAnnotation> filtered = null;
        for (int i = 0; i < annotations.annotations.length; ++i) {
            DexAnnotation annotation = annotations.annotations[i];
            if (filter.test(annotation)) {
                if (filtered == null) continue;
                filtered.add(annotation);
                continue;
            }
            if (filtered != null) continue;
            filtered = new ArrayList<DexAnnotation>(annotations.annotations.length);
            for (int j = 0; j < i; ++j) {
                filtered.add(annotations.annotations[j]);
            }
        }
        if (filtered == null) {
            return annotations;
        }
        if (filtered.isEmpty()) {
            return DexAnnotationSet.empty();
        }
        return new DexAnnotationSet(filtered.toArray(new DexAnnotation[filtered.size()]));
    }
}

