/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.org.apache.commons.compress.archivers.zip;

import com.android.tools.r8.org.apache.commons.compress.archivers.zip.ZipEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;

class FallbackZipEncoding
implements ZipEncoding {
    private final String charsetName;

    public FallbackZipEncoding() {
        this.charsetName = null;
    }

    public FallbackZipEncoding(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    public boolean canEncode(String name) {
        return true;
    }

    @Override
    public ByteBuffer encode(String name) throws IOException {
        if (this.charsetName == null) {
            return ByteBuffer.wrap(name.getBytes());
        }
        return ByteBuffer.wrap(name.getBytes(this.charsetName));
    }

    @Override
    public String decode(byte[] data) throws IOException {
        if (this.charsetName == null) {
            return new String(data);
        }
        return new String(data, this.charsetName);
    }
}

