/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Aput;
import com.android.tools.r8.code.AputBoolean;
import com.android.tools.r8.code.AputByte;
import com.android.tools.r8.code.AputChar;
import com.android.tools.r8.code.AputObject;
import com.android.tools.r8.code.AputShort;
import com.android.tools.r8.code.AputWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;

public class ArrayPut
extends Instruction {
    private final MemberType type;

    public ArrayPut(MemberType type, List<Value> ins) {
        super(null, ins);
        assert (type != null);
        this.type = type;
    }

    public Value source() {
        return (Value)this.inValues.get(0);
    }

    public Value array() {
        return (Value)this.inValues.get(1);
    }

    public Value index() {
        return (Value)this.inValues.get(2);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int source = builder.allocatedRegister(this.source(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case SINGLE: {
                instruction = new Aput(source, array, index);
                break;
            }
            case WIDE: {
                instruction = new AputWide(source, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AputObject(source, array, index);
                break;
            }
            case BOOLEAN: {
                instruction = new AputBoolean(source, array, index);
                break;
            }
            case BYTE: {
                instruction = new AputByte(source, array, index);
                break;
            }
            case CHAR: {
                instruction = new AputChar(source, array, index);
                break;
            }
            case SHORT: {
                instruction = new AputShort(source, array, index);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "ArrayPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        Value newArraySizeValue;
        if (this.index().isConstant() && !this.array().isPhi() && this.array().definition.isNewArrayEmpty() && (newArraySizeValue = this.array().definition.asNewArrayEmpty().size()).isConstant()) {
            int newArraySize = newArraySizeValue.getConstInstruction().asConstNumber().getIntValue();
            int index = this.index().getConstInstruction().asConstNumber().getIntValue();
            return newArraySize <= 0 || index < 0 || newArraySize <= index;
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(IRCode code, InternalOptions options) {
        return false;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asArrayPut().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asArrayPut().type.ordinal();
    }

    @Override
    public boolean isArrayPut() {
        return true;
    }

    @Override
    public ArrayPut asArrayPut() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.ALWAYS;
    }
}

