/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.code.ConstString;
import com.android.tools.r8.code.ConstStringJumbo;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.ProguardClassFilter;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Map;

class IdentifierMinifier {
    private final AppInfo appInfo;
    private final ProguardClassFilter adaptClassStrings;
    private final NamingLens lens;

    IdentifierMinifier(AppInfo appInfo, ProguardClassFilter adaptClassStrings, NamingLens lens) {
        this.appInfo = appInfo;
        this.adaptClassStrings = adaptClassStrings;
        this.lens = lens;
    }

    void run() {
        if (!this.adaptClassStrings.isEmpty()) {
            this.handleAdaptClassStrings();
        }
    }

    private void handleAdaptClassStrings() {
        this.appInfo.classes().forEach(clazz -> {
            if (!this.adaptClassStrings.matches(clazz.type)) {
                return;
            }
            clazz.forEachField(encodedField -> {
                DexString original;
                DexString renamed;
                if (encodedField.staticValue instanceof DexValue.DexValueString && (renamed = this.getRenamedStringLiteral(original = ((DexValue.DexValueString)encodedField.staticValue).getValue())) != original) {
                    encodedField.staticValue = new DexValue.DexValueString(renamed);
                }
            });
            clazz.forEachMethod(encodedMethod -> {
                if (encodedMethod.accessFlags.isAbstract()) {
                    return;
                }
                Code code = encodedMethod.getCode();
                if (code == null) {
                    return;
                }
                assert (code.isDexCode());
                DexCode dexCode = code.asDexCode();
                for (Instruction instr : dexCode.instructions) {
                    DexString dexString;
                    Instruction cnst;
                    if (instr instanceof ConstString) {
                        cnst = (ConstString)instr;
                        dexString = ((ConstString)cnst).getString();
                        ((ConstString)cnst).BBBB = this.getRenamedStringLiteral(dexString);
                        continue;
                    }
                    if (!(instr instanceof ConstStringJumbo)) continue;
                    cnst = (ConstStringJumbo)instr;
                    dexString = ((ConstStringJumbo)cnst).getString();
                    ((ConstStringJumbo)cnst).BBBBBBBB = this.getRenamedStringLiteral(dexString);
                }
            });
        });
    }

    private DexString getRenamedStringLiteral(DexString originalLiteral) {
        DexString renamed;
        String originalString = originalLiteral.toString();
        Map<String, DexType> renamedYetMatchedTypes = this.lens.getRenamedItems(DexType.class, type -> type.toSourceString().equals(originalString), DexType::toSourceString);
        DexType type2 = renamedYetMatchedTypes.get(originalString);
        if (type2 != null && (renamed = this.lens.lookupDescriptor(type2)) != originalLiteral) {
            return this.appInfo.dexItemFactory.createString(DescriptorUtils.descriptorToJavaType(renamed.toString()));
        }
        return originalLiteral;
    }
}

