/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.naming.ClassNameMapper;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class DescriptorUtils {
    public static final char DESCRIPTOR_PACKAGE_SEPARATOR = '/';
    public static final char JAVA_PACKAGE_SEPARATOR = '.';
    private static final Map<String, String> typeNameToLetterMap = ImmutableMap.builder().put("void", "V").put("boolean", "Z").put("byte", "B").put("short", "S").put("char", "C").put("int", "I").put("long", "J").put("float", "F").put("double", "D").build();

    private static String internalToDescriptor(String typeName, boolean shorty) {
        String descriptor = typeNameToLetterMap.get(typeName);
        if (descriptor != null) {
            return descriptor;
        }
        if (shorty) {
            return "L";
        }
        if (typeName.endsWith("[]")) {
            return "[" + DescriptorUtils.internalToDescriptor(typeName.substring(0, typeName.length() - 2), shorty);
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    public static String javaTypeToDescriptor(String typeName) {
        assert (typeName.indexOf(47) == -1);
        return DescriptorUtils.internalToDescriptor(typeName, false);
    }

    public static String javaTypeToShorty(String typeName) {
        return DescriptorUtils.internalToDescriptor(typeName, true);
    }

    public static String descriptorToJavaType(String descriptor) {
        return DescriptorUtils.descriptorToJavaType(descriptor, null);
    }

    public static String descriptorToJavaType(String descriptor, ClassNameMapper classNameMapper) {
        switch (descriptor.charAt(0)) {
            case 'L': {
                assert (descriptor.charAt(descriptor.length() - 1) == ';');
                String clazz = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
                String originalName = classNameMapper == null ? clazz : classNameMapper.deobfuscateClassName(clazz);
                return originalName;
            }
            case '[': {
                return DescriptorUtils.descriptorToJavaType(descriptor.substring(1, descriptor.length()), classNameMapper) + "[]";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw new Unreachable("Unknown type " + descriptor);
    }

    public static String getSimpleClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getSimpleClassNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor));
    }

    public static String getClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor).replace('/', '.');
    }

    public static String getPackageNameFromDescriptor(String descriptor) {
        return DescriptorUtils.getPackageNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(descriptor));
    }

    public static String getClassBinaryNameFromDescriptor(String classDescriptor) {
        assert (DescriptorUtils.isClassDescriptor(classDescriptor)) : "Invalid class descriptor " + classDescriptor;
        return classDescriptor.substring(1, classDescriptor.length() - 1);
    }

    public static String getPackageBinaryNameFromJavaType(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getDescriptorFromClassBinaryName(String typeBinaryName) {
        return 'L' + typeBinaryName + ';';
    }

    public static String getSimpleClassNameFromBinaryName(String classBinaryName) {
        int simpleNameIndex = classBinaryName.lastIndexOf(47);
        return simpleNameIndex < 0 ? classBinaryName : classBinaryName.substring(simpleNameIndex + 1);
    }

    public static boolean isClassDescriptor(String descriptor) {
        char ch;
        char[] buffer = descriptor.toCharArray();
        int length = buffer.length;
        if (length < 3 || buffer[0] != 'L') {
            return false;
        }
        int pos = 1;
        do {
            if (pos >= length) {
                return false;
            }
            if (DescriptorUtils.isInvalidChar(ch = buffer[pos++]) || ch == '/' || ch == ';') {
                return false;
            }
            do {
                if (pos >= length) {
                    return false;
                }
                if (!DescriptorUtils.isInvalidChar(ch = buffer[pos++])) continue;
                return false;
            } while (ch != '/' && ch != ';');
        } while (ch != ';');
        return pos == length;
    }

    public static String getPackageNameFromBinaryName(String classBinaryName) {
        int nameIndex = classBinaryName.lastIndexOf(47);
        return nameIndex < 0 ? "" : classBinaryName.substring(0, nameIndex).replace('/', '.');
    }

    private static boolean isInvalidChar(char ch) {
        switch (ch) {
            case '.': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static String guessTypeDescriptor(Path name) {
        return DescriptorUtils.guessTypeDescriptor(name.toString());
    }

    public static String guessTypeDescriptor(String name) {
        assert (name != null);
        assert (name.endsWith(".class")) : "Name " + name + " must have " + ".class" + " suffix";
        String fileName = File.separatorChar == '/' ? name.toString() : name.toString().replace(File.separatorChar, '/');
        String descriptor = fileName.substring(0, fileName.length() - ".class".length());
        if (descriptor.contains(".")) {
            throw new CompilationError("Unexpected class file name: " + fileName);
        }
        return 'L' + descriptor + ';';
    }
}

