/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.OutputSink;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.tree.ClassNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.util.CheckClassAdapter;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.concurrent.ExecutorService;

public class CfApplicationWriter {
    private final DexApplication application;
    private final InternalOptions options;

    public CfApplicationWriter(DexApplication application, InternalOptions options) {
        this.application = application;
        this.options = options;
    }

    public void write(OutputSink outputSink, ExecutorService executor) throws IOException {
        this.application.timing.begin("CfApplicationWriter.write");
        try {
            this.writeApplication(outputSink, executor);
        }
        finally {
            this.application.timing.end();
        }
    }

    private void writeApplication(OutputSink outputSink, ExecutorService executor) throws IOException {
        for (DexProgramClass clazz : this.application.classes()) {
            if (clazz.getSynthesizedFrom().isEmpty()) {
                this.writeClass(clazz, outputSink);
                continue;
            }
            throw new Unimplemented("No support for synthetics in the Java bytecode backend.");
        }
    }

    private void writeClass(DexProgramClass clazz, OutputSink outputSink) throws IOException {
        ClassWriter writer = new ClassWriter(2);
        writer.visitSource(clazz.sourceFile.toString(), null);
        int version = clazz.getClassFileVersion();
        int access = clazz.accessFlags.getAsCfAccessFlags();
        String desc = clazz.type.toDescriptorString();
        String name = CfApplicationWriter.internalName(clazz.type);
        String signature = null;
        String superName = clazz.type == this.options.itemFactory.objectType ? null : CfApplicationWriter.internalName(clazz.superType);
        String[] interfaces = new String[clazz.interfaces.values.length];
        for (int i = 0; i < clazz.interfaces.values.length; ++i) {
            interfaces[i] = CfApplicationWriter.internalName(clazz.interfaces.values[i]);
        }
        writer.visit(version, access, name, signature, superName, interfaces);
        for (DexEncodedMethod method : clazz.directMethods()) {
            this.writeMethod(method, writer);
        }
        writer.visitEnd();
        byte[] result = writer.toByteArray();
        assert (CfApplicationWriter.verifyCf(result));
        outputSink.writeClassFile(result, Collections.singleton(desc), desc);
    }

    private void writeMethod(DexEncodedMethod method, ClassWriter writer) {
        int access = method.accessFlags.getAsCfAccessFlags();
        String name = method.method.name.toString();
        String desc = method.descriptor();
        String signature = null;
        String[] exceptions = null;
        MethodVisitor visitor = writer.visitMethod(access, name, desc, signature, exceptions);
        this.writeCode(method.getCode(), visitor);
    }

    private void writeCode(Code code, MethodVisitor visitor) {
        if (code.isJarCode()) {
            code.asJarCode().writeTo(visitor);
        } else {
            assert (code.isCfCode());
            code.asCfCode().write(visitor);
        }
    }

    private static String internalName(DexType type) {
        return Type.getType(type.toDescriptorString()).getInternalName();
    }

    private String printCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        ClassNode node = new ClassNode(393216);
        reader.accept(node, 393216);
        StringWriter writer = new StringWriter();
        for (MethodNode method : node.methods) {
            TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
            method.accept(visitor);
            visitor.p.print(new PrintWriter(writer));
            writer.append('\n');
        }
        return writer.toString();
    }

    private static boolean verifyCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        PrintWriter pw = new PrintWriter(System.out);
        CheckClassAdapter.verify(reader, false, pw);
        return true;
    }
}

