/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptQueueThreadContext;
import com.android.builder.internal.aapt.QueuedResourceProcessor;
import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.android.ide.common.internal.ResourceCompilationException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.tools.aapt2.Aapt2RenamingConventions;
import com.android.utils.ILogger;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Aapt2QueuedResourceProcessor
extends QueuedResourceProcessor {
    private Aapt2QueuedResourceProcessor(String aaptLocation, ILogger iLogger, int processesNumber) {
        super(aaptLocation, iLogger, processesNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<File> compile(int key, final CompileResourceRequest request, final ProcessOutputHandler processOutputHandler) throws ResourceCompilationException {
        final SettableFuture result = SettableFuture.create();
        try {
            AaptQueueThreadContext.QueuedJob aaptProcessJob = new AaptQueueThreadContext.QueuedJob(key, "Compiling " + request.getInput().getName(), new Task<AaptProcess>(){

                @Override
                public void run(Job<AaptProcess> job, JobContext<AaptProcess> context) throws IOException {
                    AaptProcess aapt = context.getPayload();
                    if (aapt == null) {
                        Aapt2QueuedResourceProcessor.this.logger.error(null, "Thread(%1$s) has a null payload", new Object[]{Thread.currentThread().getName()});
                        return;
                    }
                    aapt.compile(request, job, processOutputHandler);
                }

                @Override
                public void finished() {
                    result.set((Object)new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput())));
                }

                @Override
                public void error(Throwable e) {
                    result.setException(e);
                }

                public String toString() {
                    return MoreObjects.toStringHelper((Object)this).add("from", (Object)request.getInput().getAbsolutePath()).add("to", (Object)request.getOutput().getAbsolutePath()).toString();
                }
            }, (ListenableFuture<File>)result);
            Map map = this.outstandingJobs;
            synchronized (map) {
                this.outstandingJobs.computeIfAbsent(key, k -> new ConcurrentLinkedQueue());
            }
            this.processingRequests.push(aaptProcessJob);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ResourceCompilationException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<File> link(int key, final AaptPackageConfig config, final File intermediateDir, final ProcessOutputHandler processOutputHandler) throws ResourceCompilationException {
        final SettableFuture result = SettableFuture.create();
        try {
            AaptQueueThreadContext.QueuedJob aaptProcessJob = new AaptQueueThreadContext.QueuedJob(key, "Linking", new Task<AaptProcess>(){

                @Override
                public void run(Job<AaptProcess> job, JobContext<AaptProcess> context) throws IOException {
                    AaptProcess aapt = context.getPayload();
                    if (aapt == null) {
                        Aapt2QueuedResourceProcessor.this.logger.error(null, "Thread(%1$s) has a null payload", new Object[]{Thread.currentThread().getName()});
                        return;
                    }
                    aapt.link(config, intermediateDir, job, processOutputHandler);
                }

                @Override
                public void finished() {
                    result.set(null);
                }

                @Override
                public void error(Throwable e) {
                    result.setException(e);
                }

                public String toString() {
                    return MoreObjects.toStringHelper((Object)this).add("config", (Object)config.toString()).toString();
                }
            }, (ListenableFuture<File>)result);
            Map map = this.outstandingJobs;
            synchronized (map) {
                this.outstandingJobs.computeIfAbsent(key, k -> new ConcurrentLinkedQueue());
            }
            this.processingRequests.push(aaptProcessJob);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ResourceCompilationException((Throwable)e);
        }
        return result;
    }

    public static void invalidateProcess(String aaptLocation) {
        Creator.INSTANCE.invalidateProcessor(aaptLocation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String aaptLocation;
        private ILogger logger;
        private int processesNumber = 0;

        public Builder executablePath(String aaptLocation) {
            this.aaptLocation = aaptLocation;
            return this;
        }

        public Builder logger(ILogger logger) {
            this.logger = logger;
            return this;
        }

        public Builder numberOfProcesses(int processesNumber) {
            this.processesNumber = processesNumber;
            return this;
        }

        public Aapt2QueuedResourceProcessor build() {
            return Creator.INSTANCE.newProcessor(this.aaptLocation, this.logger, this.processesNumber);
        }
    }

    private static enum Creator {
        INSTANCE;

        private final Map<String, Aapt2QueuedResourceProcessor> sInstances = new ConcurrentHashMap<String, Aapt2QueuedResourceProcessor>();
        private final Object sLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Aapt2QueuedResourceProcessor newProcessor(String aaptLocation, ILogger logger, int processesNumber) {
            Object object = this.sLock;
            synchronized (object) {
                logger.verbose("Aapt2QueuedResourceProcessor is using %1$s%n", new Object[]{aaptLocation});
                if (!this.sInstances.containsKey(aaptLocation)) {
                    Aapt2QueuedResourceProcessor processor = new Aapt2QueuedResourceProcessor(aaptLocation, logger, processesNumber);
                    this.sInstances.put(aaptLocation, processor);
                }
                return this.sInstances.get(aaptLocation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateProcessor(String aaptLocation) {
            Object object = this.sLock;
            synchronized (object) {
                this.sInstances.remove(aaptLocation);
            }
        }
    }
}

