/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AbstractAapt;
import com.android.builder.internal.aapt.v2.Aapt2QueuedResourceProcessor;
import com.android.ide.common.internal.ResourceCompilationException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.sdklib.BuildToolInfo;
import com.android.tools.aapt2.Aapt2Exception;
import com.android.tools.aapt2.Aapt2RenamingConventions;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class QueueableAapt2
extends AbstractAapt {
    private static final long AUTO_THREAD_SHUTDOWN_MS = 250L;
    private final Aapt2QueuedResourceProcessor aapt;
    private final Executor executor;
    private final File intermediateDir;
    private final Integer requestKey;
    private final ProcessOutputHandler processOutputHandler;

    public QueueableAapt2(ProcessOutputHandler processOutputHandler, BuildToolInfo buildToolInfo, File intermediateDir, ILogger logger, int numberOfProcesses) {
        this(processOutputHandler, QueueableAapt2.getAapt2ExecutablePath(buildToolInfo), intermediateDir, logger, numberOfProcesses);
    }

    QueueableAapt2(ProcessOutputHandler processOutputHandler, String aapt2ExecutablePath, File intermediateDir, ILogger logger, int numberOfProcesses) {
        Preconditions.checkArgument((boolean)intermediateDir.isDirectory(), (String)"Intermediate directory needs to be a directory.\nintermediateDir: %s", (Object)intermediateDir.getAbsolutePath());
        this.intermediateDir = intermediateDir;
        this.processOutputHandler = processOutputHandler;
        this.executor = new ThreadPoolExecutor(0, 1, 250L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.aapt = Aapt2QueuedResourceProcessor.builder().executablePath(aapt2ExecutablePath).logger(logger).numberOfProcesses(numberOfProcesses).build();
        this.requestKey = this.aapt.start();
    }

    public void close() throws IOException {
        try {
            this.aapt.end(this.requestKey);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public Future<File> compile(CompileResourceRequest request) throws Exception {
        ListenableFuture<File> futureResult;
        Preconditions.checkArgument((boolean)request.getInput().isFile(), (String)"Input file needs to be a normal file.\nInput file: %s", (Object)request.getInput().getAbsolutePath());
        Preconditions.checkArgument((boolean)request.getOutput().isDirectory(), (String)"Output for resource compilation needs to be a directory.\nOutput: %s", (Object)request.getOutput().getAbsolutePath());
        SettableFuture actualResult = SettableFuture.create();
        try {
            futureResult = this.aapt.compile(this.requestKey, request, this.processOutputHandler);
        }
        catch (ResourceCompilationException e) {
            throw new Aapt2Exception(String.format("Failed to compile file %s", request.getInput()), e);
        }
        futureResult.addListener(() -> {
            try {
                actualResult.set(futureResult.get());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                actualResult.setException((Throwable)e);
            }
            catch (ExecutionException e) {
                actualResult.setException((Throwable)e);
            }
        }, this.executor);
        return actualResult;
    }

    @Override
    protected ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig config) throws AaptException {
        ListenableFuture<File> futureResult;
        SettableFuture actualResult = SettableFuture.create();
        try {
            futureResult = this.aapt.link(this.requestKey, config, this.intermediateDir, this.processOutputHandler);
        }
        catch (Exception e) {
            throw new AaptException("Failed to link", new Object[]{e});
        }
        futureResult.addListener(() -> {
            try {
                futureResult.get();
                actualResult.set(null);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                actualResult.setException((Throwable)e);
            }
            catch (ExecutionException e) {
                actualResult.setException((Throwable)e);
            }
        }, this.executor);
        return actualResult;
    }

    public File compileOutputFor(CompileResourceRequest request) {
        return new File(request.getOutput(), Aapt2RenamingConventions.compilationRename(request.getInput()));
    }

    private static String getAapt2ExecutablePath(BuildToolInfo buildToolInfo) {
        Preconditions.checkArgument((boolean)BuildToolInfo.PathId.DAEMON_AAPT2.isPresentIn(buildToolInfo.getRevision()), (String)"Aapt2 with daemon mode requires newer build tools.\nCurrent version %s, minimum required %s.", (Object)buildToolInfo.getRevision(), (Object)BuildToolInfo.PathId.DAEMON_AAPT2.getMinRevision());
        String aapt2 = buildToolInfo.getPath(BuildToolInfo.PathId.DAEMON_AAPT2);
        if (aapt2 == null || !new File(aapt2).isFile()) {
            throw new IllegalStateException("aapt2 is missing on '" + aapt2 + "'");
        }
        return aapt2;
    }
}

