/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.aapt2;

import com.android.tools.aapt2.Aapt2JniLogCallback;
import com.android.tools.aapt2.AutoValue_Aapt2Result;
import com.android.tools.aapt2.AutoValue_Aapt2Result_Message;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public abstract class Aapt2Result {
    public abstract int getReturnCode();

    @Nonnull
    public abstract ImmutableList<Message> getMessages();

    public static Builder builder() {
        return new AutoValue_Aapt2Result.Builder();
    }

    public static abstract class Builder
    implements Aapt2JniLogCallback {
        @Override
        public void log(int levelValue, @Nonnull String path, long line, @Nonnull String message) {
            this.messagesBuilder().add((Object)Message.create(Aapt2JniLogCallback.intToLogLevel(levelValue), path, line, message));
        }

        public abstract Builder setReturnCode(int var1);

        abstract ImmutableList.Builder<Message> messagesBuilder();

        public abstract Aapt2Result build();
    }

    public static abstract class Message {
        static Message create(@Nonnull LogLevel level, @Nonnull String path, long line, @Nonnull String message) {
            return new AutoValue_Aapt2Result_Message(level, path, line, message);
        }

        @Nonnull
        public abstract LogLevel getLevel();

        @Nonnull
        public abstract String getPath();

        public abstract long getLine();

        @Nonnull
        public abstract String getMessage();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getLevel().name()).append(": ").append(this.getPath());
            if (this.getLine() != -1L) {
                builder.append(":").append(this.getLine());
            }
            builder.append(" ").append(this.getMessage());
            return builder.toString();
        }

        public static enum LogLevel {
            NOTE,
            WARN,
            ERROR;

        }
    }
}

