/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final Path mainDexListOutput;
    private final DexItemFactory factory;
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));

    public Path getMainDexListOutputPath() {
        return this.mainDexListOutput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        Builder builder = GenerateMainDexListCommand.builder();
        GenerateMainDexListCommand.parse(args, builder);
        return builder;
    }

    private static void parse(String[] args, Builder builder) throws CompilationException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.startsWith("--")) {
                throw new CompilationException("Unknown option: " + arg);
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
    }

    private GenerateMainDexListCommand(DexItemFactory factory, AndroidApp inputApp, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, Path mainDexListOutput) {
        super(inputApp);
        this.factory = factory;
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListOutput = mainDexListOutput;
    }

    private GenerateMainDexListCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.factory = new DexItemFactory();
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListOutput = null;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        if (this.mainDexListOutput != null) {
            internal.printMainDexListFile = this.mainDexListOutput;
        }
        internal.minimalMainDex = internal.debug;
        internal.removeSwitchMaps = false;
        internal.inlineAccessors = false;
        return internal;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final DexItemFactory factory = new DexItemFactory();
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Path mainDexListOutput = null;

        @Override
        Builder self() {
            return this;
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines) {
            this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0])));
            return this.self();
        }

        public Path getMainDexListOutputPath() {
            return this.mainDexListOutput;
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListOutput = mainDexListOutputPath;
            return this.self();
        }

        @Override
        public GenerateMainDexListCommand build() throws CompilationException, IOException {
            ImmutableList<Object> mainDexKeepRules;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new GenerateMainDexListCommand(this.isPrintHelp(), this.isPrintVersion());
            }
            this.validate();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(this.factory, new DefaultDiagnosticsHandler());
                try {
                    parser.parse(this.mainDexRules);
                    mainDexKeepRules = parser.getConfig().getRules();
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
            }
            return new GenerateMainDexListCommand(this.factory, this.getAppBuilder().build(), mainDexKeepRules, this.mainDexListOutput);
        }
    }
}

