/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.shaking.ProguardRuleParserException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: r8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --release                # Compile without debugging information (default).", "  --debug                  # Compile with debugging information.", "  --output <file>          # Output result in <file>.", "                           # <file> must be an existing directory or a zip file.", "  --lib <file>             # Add <file> as a library resource.", "  --min-api                # Minimum Android API level compatibility.", "  --pg-conf <file>         # Proguard configuration <file> (implies tree", "                           # shaking/minification).", "  --pg-map-output <file>   # Output the resulting name and line mapping to <file>.", new String[]{"  --no-tree-shaking        # Force disable tree shaking of unreachable classes.", "  --no-discarded-checker   # Force disable the discarded checker (when tree shaking).", "  --no-minification        # Force disable minification of names.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version of r8.", "  --help                   # Print this message."}));
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final Path mainDexListOutput;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean useTreeShaking;
    private final boolean useDiscardedChecker;
    private final boolean useMinification;
    private final boolean ignoreMissingClasses;
    private final boolean forceProguardCompatibility;
    private final boolean ignoreMissingClassesWhenNotShrinking;
    private final Path proguardMapOutput;

    public static Builder builder() {
        return new Builder();
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args) throws CompilationException, IOException {
        Builder builder = R8Command.builder();
        R8Command.parse(args, builder, new ParseState());
        return builder;
    }

    private static ParseState parse(String[] args, Builder builder, ParseState state) throws CompilationException, IOException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.DEBUG;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    throw new CompilationException("Cannot compile in both --debug and --release mode.");
                }
                state.mode = CompilationMode.RELEASE;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--output")) {
                String outputPath = args[++i];
                if (builder.getOutputPath() != null) {
                    throw new CompilationException("Cannot output both to '" + builder.getOutputPath().toString() + "' and '" + outputPath + "'");
                }
                builder.setOutputPath(Paths.get(outputPath, new String[0]));
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                builder.setMinApiLevel(Integer.valueOf(args[++i]));
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setTreeShaking(false);
                continue;
            }
            if (arg.equals("--no-discarded-checker")) {
                builder.setDiscardedChecker(false);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setMinification(false);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--ignore-missing-classes")) {
                builder.setIgnoreMissingClasses(true);
                continue;
            }
            if (arg.equals("--pg-map-output")) {
                builder.setProguardMapOutput(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.startsWith("@")) {
                String argsFile = arg.substring(1);
                try {
                    List<String> linesInFile = FileUtils.readTextFile(Paths.get(argsFile, new String[0]));
                    ArrayList<String> argsInFile = new ArrayList<String>();
                    for (String line : linesInFile) {
                        for (String word : line.split("\\s")) {
                            String trimmed = word.trim();
                            if (trimmed.isEmpty()) continue;
                            argsInFile.add(trimmed);
                        }
                    }
                    state = R8Command.parse(argsInFile.toArray(new String[argsInFile.size()]), builder, state);
                    continue;
                }
                catch (CompilationException | IOException e) {
                    throw new CompilationException("Failed to read arguments from file " + argsFile + ": " + e.getMessage());
                }
            }
            if (arg.startsWith("--")) {
                throw new CompilationException("Unknown option: " + arg);
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        return state;
    }

    private R8Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, Path mainDexListOutput, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, DiagnosticsHandler diagnosticsHandler, boolean enableDesugaring, boolean useTreeShaking, boolean useDiscardedChecker, boolean useMinification, boolean ignoreMissingClasses, boolean forceProguardCompatibility, boolean ignoreMissingClassesWhenNotShrinking, Path proguardMapOutput) {
        super(inputApp, outputPath, outputMode, mode, minApiLevel, diagnosticsHandler, enableDesugaring);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        assert (this.getOutputMode() == OutputMode.Indexed) : "Only regular mode is supported in R8";
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListOutput = mainDexListOutput;
        this.proguardConfiguration = proguardConfiguration;
        this.useTreeShaking = useTreeShaking;
        this.useDiscardedChecker = useDiscardedChecker;
        this.useMinification = useMinification;
        this.ignoreMissingClasses = ignoreMissingClasses;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.ignoreMissingClassesWhenNotShrinking = ignoreMissingClassesWhenNotShrinking;
        this.proguardMapOutput = proguardMapOutput;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListOutput = null;
        this.proguardConfiguration = null;
        this.useTreeShaking = false;
        this.useDiscardedChecker = false;
        this.useMinification = false;
        this.ignoreMissingClasses = false;
        this.forceProguardCompatibility = false;
        this.ignoreMissingClassesWhenNotShrinking = false;
        this.proguardMapOutput = null;
    }

    public boolean useTreeShaking() {
        return this.useTreeShaking;
    }

    public boolean useDiscardedChecker() {
        return this.useDiscardedChecker;
    }

    public boolean useMinification() {
        return this.useMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration);
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.minApiLevel = this.getMinApiLevel();
        if (!this.proguardConfiguration.isOptimizing()) {
            internal.skipDebugLineNumberOpt = true;
            internal.skipClassMerging = true;
            internal.inlineAccessors = false;
            internal.removeSwitchMaps = false;
            internal.outline.enabled = false;
            internal.propagateMemberValue = false;
        }
        assert (!internal.skipMinification);
        boolean bl = internal.skipMinification = !this.useMinification() || !this.proguardConfiguration.isObfuscating();
        assert (internal.useTreeShaking);
        internal.useTreeShaking = this.useTreeShaking();
        assert (internal.useDiscardedChecker);
        internal.useDiscardedChecker = this.useDiscardedChecker();
        assert (!internal.ignoreMissingClasses);
        internal.ignoreMissingClasses = this.ignoreMissingClasses;
        internal.ignoreMissingClasses |= this.proguardConfiguration.isIgnoreWarnings();
        internal.ignoreMissingClasses = internal.ignoreMissingClasses | (this.ignoreMissingClassesWhenNotShrinking && !this.proguardConfiguration.isShrinking());
        assert (!internal.verbose);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = internal.debug;
        if (this.mainDexListOutput != null) {
            internal.printMainDexListFile = this.mainDexListOutput;
        }
        internal.outputMode = this.getOutputMode();
        if (internal.debug) {
            internal.removeSwitchMaps = false;
            internal.inlineAccessors = false;
        }
        internal.proguardMapOutput = this.proguardMapOutput;
        assert (!internal.forceProguardCompatibility);
        internal.forceProguardCompatibility = this.forceProguardCompatibility;
        return internal;
    }

    private static class ParseState {
        CompilationMode mode = null;

        private ParseState() {
        }
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Path mainDexListOutput = null;
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> discardedChecker = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private boolean ignoreMissingClassesWhenNotShrinking = false;
        private boolean ignoreMissingClasses = false;
        private boolean forceProguardCompatibility = false;
        private Path proguardMapOutput = null;

        private Builder() {
            super(CompilationMode.RELEASE);
        }

        protected Builder(boolean ignoreDexInArchive, boolean forceProguardCompatibility, boolean ignoreMissingClassesWhenNotShrinking, boolean ignoreMissingClasses) {
            super(CompilationMode.RELEASE, ignoreDexInArchive);
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.ignoreMissingClassesWhenNotShrinking = ignoreMissingClassesWhenNotShrinking;
            this.ignoreMissingClasses = ignoreMissingClasses;
        }

        private Builder(AndroidApp app) {
            super(CompilationMode.RELEASE, app);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setTreeShaking(boolean useTreeShaking) {
            this.treeShaking = Optional.of(useTreeShaking);
            return this.self();
        }

        public Builder setDiscardedChecker(boolean useDiscardedChecker) {
            this.discardedChecker = Optional.of(useDiscardedChecker);
            return this.self();
        }

        public Builder setMinification(boolean useMinification) {
            this.minification = Optional.of(useMinification);
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            for (Path path : paths) {
                this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines) {
            this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0])));
            return this.self();
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListOutput = mainDexListOutputPath;
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            for (Path path : paths) {
                this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            for (Path path : paths) {
                this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
            }
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines) {
            this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0])));
            return this.self();
        }

        public Builder addProguardConfigurationConsumer(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumer;
            this.proguardConfigurationConsumer = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
            return this.self();
        }

        public Builder setProguardMapFile(Path path) {
            this.getAppBuilder().setProguardMapFile(path);
            return this.self();
        }

        Builder setIgnoreMissingClasses(boolean ignoreMissingClasses) {
            this.ignoreMissingClasses = ignoreMissingClasses;
            return this.self();
        }

        public Builder setProguardMapOutput(Path path) {
            this.proguardMapOutput = path;
            return this.self();
        }

        @Override
        protected void validate() throws CompilationException {
            super.validate();
            if (this.mainDexListOutput != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                throw new CompilationException("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
        }

        @Override
        public R8Command build() throws CompilationException, IOException {
            ProguardConfiguration.Builder configurationBuilder;
            ImmutableList<Object> mainDexKeepRules;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new R8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.validate();
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.getDiagnosticsHandler());
                try {
                    parser.parse(this.mainDexRules);
                    mainDexKeepRules = parser.getConfig().getRules();
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
            }
            if (this.proguardConfigs.isEmpty()) {
                configurationBuilder = ProguardConfiguration.builder(factory);
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.getDiagnosticsHandler());
                try {
                    parser.parse(this.proguardConfigs);
                }
                catch (ProguardRuleParserException e) {
                    throw new CompilationException(e.getMessage(), e.getCause());
                }
                configurationBuilder = parser.getConfigurationBuilder();
                configurationBuilder.setForceProguardCompatibility(this.forceProguardCompatibility);
            }
            if (this.proguardConfigurationConsumer != null) {
                this.proguardConfigurationConsumer.accept(configurationBuilder);
            }
            ProguardConfiguration configuration = configurationBuilder.build();
            this.getAppBuilder().addProgramFiles(configuration.getInjars());
            this.getAppBuilder().addLibraryFiles(configuration.getLibraryjars());
            boolean useTreeShaking = this.treeShaking.orElse(configuration.isShrinking());
            boolean useDiscardedChecker = this.discardedChecker.orElse(true);
            boolean useMinification = this.minification.orElse(configuration.isObfuscating());
            return new R8Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), mainDexKeepRules, this.mainDexListOutput, configuration, this.getMode(), this.getMinApiLevel(), this.getDiagnosticsHandler(), this.getEnableDesugaring(), useTreeShaking, useDiscardedChecker, useMinification, this.ignoreMissingClasses, this.forceProguardCompatibility, this.ignoreMissingClassesWhenNotShrinking, this.proguardMapOutput);
        }
    }
}

