/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;

public abstract class Resource {
    public final Origin origin;

    protected Resource(Origin origin) {
        this.origin = origin;
    }

    public static Resource fromFile(Path file) {
        return new FileResource(file);
    }

    public static Resource fromBytes(Origin origin, byte[] bytes) {
        return Resource.fromBytes(origin, bytes, null);
    }

    public static Resource fromBytes(Origin origin, byte[] bytes, Set<String> typeDescriptors) {
        return new ByteResource(origin, bytes, typeDescriptors);
    }

    public abstract Set<String> getClassDescriptors();

    public abstract InputStream getStream() throws IOException;

    private static class ByteResource
    extends Resource {
        final Set<String> classDescriptors;
        final byte[] bytes;

        ByteResource(Origin origin, byte[] bytes, Set<String> classDescriptors) {
            super(origin);
            assert (bytes != null);
            this.classDescriptors = classDescriptors;
            this.bytes = bytes;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private static class FileResource
    extends Resource {
        final Path file;

        FileResource(Path file) {
            super(new PathOrigin(file, Origin.root()));
            assert (file != null);
            this.file = file;
        }

        @Override
        public Set<String> getClassDescriptors() {
            return null;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file.toFile());
        }
    }
}

