/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.cf.code.CfArrayLoad;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfGoto;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfIfCmp;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfPop;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStaticGet;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueType;
import java.util.HashMap;
import java.util.Map;

public class CfPrinter {
    private final String indent;
    private final Map<CfLabel, String> labels;
    private final StringBuilder builder = new StringBuilder();

    public CfPrinter() {
        this.indent = "";
        this.labels = null;
    }

    public CfPrinter(CfCode code) {
        this.indent = "  ";
        this.labels = new HashMap<CfLabel, String>();
        int nextLabelNumber = 0;
        for (CfInstruction instruction : code.getInstructions()) {
            if (!(instruction instanceof CfLabel)) continue;
            this.labels.put((CfLabel)instruction, "L" + nextLabelNumber++);
        }
        this.builder.append(".method ");
        this.appendMethod(code.getMethod());
        this.newline();
        this.builder.append(".limit stack ").append(code.getMaxStack());
        this.newline();
        this.builder.append(".limit locals ").append(code.getMaxLocals());
        for (CfInstruction instruction : code.getInstructions()) {
            instruction.print(this);
        }
        this.newline();
        this.builder.append(".end method");
        this.newline();
    }

    private void print(String name) {
        this.indent();
        this.builder.append(name);
    }

    public void print(CfConstNull constNull) {
        this.print("aconst_null");
    }

    public void print(CfConstNumber constNumber) {
        this.indent();
        switch (constNumber.getType()) {
            case INT: {
                this.builder.append("ldc ").append(constNumber.getIntValue());
                break;
            }
            case FLOAT: {
                this.builder.append("ldc ").append(constNumber.getFloatValue());
                break;
            }
            case LONG: {
                this.builder.append("ldc_w ").append(constNumber.getLongValue());
                break;
            }
            case DOUBLE: {
                this.builder.append("ldc_w ").append(constNumber.getDoubleValue());
                break;
            }
            default: {
                throw new Unreachable("Unexpected const-number type: " + (Object)((Object)constNumber.getType()));
            }
        }
    }

    public void print(CfReturnVoid ret) {
        this.print("return");
    }

    public void print(CfReturn ret) {
        this.print(this.typePrefix(ret.getType()) + "return");
    }

    public void print(CfPop pop) {
        this.print("pop");
    }

    public void print(CfConstString constString) {
        this.indent();
        this.builder.append("ldc ").append(constString.getString());
    }

    public void print(CfArrayLoad arrayLoad) {
        switch (arrayLoad.getType()) {
            case OBJECT: {
                this.print("aaload");
                break;
            }
            case BOOLEAN: 
            case BYTE: {
                this.print("baload");
                break;
            }
            case CHAR: {
                this.print("caload");
                break;
            }
            case SHORT: {
                this.print("saload");
                break;
            }
            case INT: {
                this.print("iaload");
                break;
            }
            case FLOAT: {
                this.print("faload");
                break;
            }
            case LONG: {
                this.print("laload");
                break;
            }
            case DOUBLE: {
                this.print("daload");
                break;
            }
            default: {
                throw new Unreachable("Unexpected array-load type: " + (Object)((Object)arrayLoad.getType()));
            }
        }
    }

    public void print(CfInvoke invoke) {
        this.indent();
        switch (invoke.getOpcode()) {
            case 182: {
                this.builder.append("invokevirtual");
                break;
            }
            case 183: {
                this.builder.append("invokespecial");
                break;
            }
            case 184: {
                this.builder.append("invokestatic");
                break;
            }
            case 185: {
                this.builder.append("invokeinterface");
                break;
            }
            case 186: {
                this.builder.append("invokedynamic");
                break;
            }
            default: {
                throw new Unreachable("Unexpected invoke opcode: " + invoke.getOpcode());
            }
        }
        this.builder.append(' ');
        this.appendMethod(invoke.getMethod());
    }

    public void print(CfFrame frame) {
        this.comment("frame");
    }

    public void print(CfStaticGet staticGet) {
        this.indent();
        this.builder.append("getstatic ");
        this.appendField(staticGet.getField());
        this.appendDescriptor(staticGet.getField().type);
    }

    public void print(CfNew newInstance) {
        this.indent();
        this.builder.append("new ");
        this.appendClass(newInstance.getType());
    }

    public void print(CfLabel label) {
        this.newline();
        this.builder.append(this.getLabel(label)).append(':');
    }

    public void print(CfGoto jump) {
        this.indent();
        this.builder.append("goto ").append(this.getLabel(jump.getTarget()));
    }

    private String ifPostfix(If.Type kind) {
        return kind.toString().toLowerCase();
    }

    public void print(CfIf conditional) {
        this.indent();
        if (conditional.getType().isObject()) {
            this.builder.append("if").append(conditional.getKind() == If.Type.EQ ? "null" : "nonnull");
        } else {
            this.builder.append("if").append(this.ifPostfix(conditional.getKind()));
        }
        this.builder.append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfIfCmp conditional) {
        this.indent();
        this.builder.append(conditional.getType().isObject() ? "if_acmp" : "if_icmp").append(this.ifPostfix(conditional.getKind())).append(' ').append(this.getLabel(conditional.getTarget()));
    }

    public void print(CfLoad load) {
        this.print(load.getType(), "load", load.getLocalIndex());
    }

    public void print(CfStore store) {
        this.print(store.getType(), "store", store.getLocalIndex());
    }

    private void print(ValueType type, String instruction, int local) {
        this.indent();
        this.builder.append(this.typePrefix(type)).append(instruction).append(' ').append(local);
    }

    private char typePrefix(ValueType type) {
        switch (type) {
            case OBJECT: {
                return 'a';
            }
            case INT: {
                return 'i';
            }
            case FLOAT: {
                return 'f';
            }
            case LONG: {
                return 'l';
            }
            case DOUBLE: {
                return 'd';
            }
        }
        throw new Unreachable("Unexpected type for prefix: " + (Object)((Object)type));
    }

    private String getLabel(CfLabel label) {
        return this.labels != null ? this.labels.get(label) : "L?";
    }

    private void newline() {
        if (this.builder.length() > 0) {
            this.builder.append('\n');
        }
    }

    private void indent() {
        this.newline();
        this.builder.append(this.indent);
    }

    private void comment(String comment) {
        this.indent();
        this.builder.append("; ").append(comment);
    }

    private void appendDescriptor(DexType type) {
        this.builder.append(type.toDescriptorString());
    }

    private void appendClass(DexType type) {
        this.builder.append(type.getInternalName());
    }

    private void appendField(DexField field) {
        this.appendClass(field.getHolder());
        this.builder.append('/').append(field.name);
    }

    private void appendMethod(DexMethod method) {
        this.builder.append(method.qualifiedName());
        this.builder.append(method.proto.toDescriptorString());
    }

    public String toString() {
        return this.builder.toString();
    }
}

