/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfInvoke
extends CfInstruction {
    private final DexMethod method;
    private final int opcode;

    public CfInvoke(int opcode, DexMethod method) {
        assert (182 <= opcode && opcode <= 186);
        this.opcode = opcode;
        this.method = method;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public void write(MethodVisitor visitor) {
        String owner = this.method.getHolder().getInternalName();
        String name = this.method.name.toString();
        String desc = this.method.proto.toDescriptorString();
        boolean iface = this.method.holder.isInterface();
        visitor.visitMethodInsn(this.opcode, owner, name, desc, iface);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }
}

