/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.FilledNewArray;
import com.android.tools.r8.code.FilledNewArrayRange;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.List;

public class InvokeNewArray
extends Invoke {
    private DexType type;

    public InvokeNewArray(DexType type, Value result, List<Value> arguments) {
        super(result, arguments);
        this.type = type;
    }

    @Override
    public DexType getReturnType() {
        return this.getArrayType();
    }

    public DexType getArrayType() {
        return this.type;
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.NEW_ARRAY;
    }

    @Override
    protected String getTypeString() {
        return "NewArray";
    }

    @Override
    public String toString() {
        return super.toString() + "; type: " + this.type.toSourceString();
    }

    @Override
    public DexEncodedMethod computeSingleTarget(AppInfoWithSubtyping appInfo) {
        return null;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new FilledNewArrayRange(firstRegister, argumentRegisters, this.type);
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new FilledNewArray(argumentRegistersCount, this.type, individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInvokeNewArray()) {
            return false;
        }
        return this.type == other.asInvokeNewArray().type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        if (!other.isInvokeNewArray()) {
            return -1;
        }
        return this.type.slowCompareTo(other.asInvokeNewArray().type);
    }

    @Override
    public boolean isInvokeNewArray() {
        return true;
    }

    @Override
    public InvokeNewArray asInvokeNewArray() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return Inliner.Constraint.classIsVisible(holder, this.type, info);
    }
}

