/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import java.util.Arrays;
import java.util.BitSet;

public class RegisterPositions {
    private static final int INITIAL_SIZE = 16;
    private int limit;
    private int[] backing;
    private BitSet registerHoldsConstant;
    private BitSet registerHoldsMonitor;

    public RegisterPositions(int limit) {
        this.limit = limit;
        this.backing = new int[16];
        for (int i = 0; i < 16; ++i) {
            this.backing[i] = Integer.MAX_VALUE;
        }
        this.registerHoldsConstant = new BitSet(limit);
        this.registerHoldsMonitor = new BitSet(limit);
    }

    public boolean hasType(int index, Type type) {
        switch (type) {
            case MONITOR: {
                return this.holdsMonitor(index);
            }
            case CONST_NUMBER: {
                return this.holdsConstant(index);
            }
            case OTHER: {
                return !this.holdsMonitor(index) && !this.holdsConstant(index);
            }
            case ANY: {
                return true;
            }
        }
        throw new Unreachable("Unexpected register position type: " + (Object)((Object)type));
    }

    private boolean holdsConstant(int index) {
        return this.registerHoldsConstant.get(index);
    }

    private boolean holdsMonitor(int index) {
        return this.registerHoldsMonitor.get(index);
    }

    public void set(int index, int value) {
        if (index >= this.backing.length) {
            this.grow(index + 1);
        }
        this.backing[index] = value;
    }

    public void set(int index, int value, LiveIntervals intervals) {
        this.set(index, value);
        this.registerHoldsConstant.set(index, intervals.isConstantNumberInterval());
        this.registerHoldsMonitor.set(index, intervals.usedInMonitorOperation());
    }

    public int get(int index) {
        if (index < this.backing.length) {
            return this.backing[index];
        }
        assert (index < this.limit);
        return Integer.MAX_VALUE;
    }

    public void grow(int minSize) {
        int size;
        for (size = this.backing.length; size < minSize; size *= 2) {
        }
        size = Math.min(size, this.limit);
        int oldSize = this.backing.length;
        this.backing = Arrays.copyOf(this.backing, size);
        for (int i = oldSize; i < size; ++i) {
            this.backing[i] = Integer.MAX_VALUE;
        }
    }

    static enum Type {
        MONITOR,
        CONST_NUMBER,
        OTHER,
        ANY;

    }
}

