/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassNamingForNameMapper
implements ClassNaming {
    public final String originalName;
    private final String renamedName;
    private final ImmutableMap<MemberNaming.MethodSignature, MemberNaming> methodMembers;
    private final ImmutableMap<MemberNaming.FieldSignature, MemberNaming> fieldMembers;

    static Builder builder(String renamedName, String originalName) {
        return new Builder(renamedName, originalName);
    }

    private ClassNamingForNameMapper(String renamedName, String originalName, Map<MemberNaming.MethodSignature, MemberNaming> methodMembers, Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers) {
        this.renamedName = renamedName;
        this.originalName = originalName;
        this.methodMembers = ImmutableMap.copyOf(methodMembers);
        this.fieldMembers = ImmutableMap.copyOf(fieldMembers);
    }

    @Override
    public MemberNaming lookup(MemberNaming.Signature renamedSignature) {
        if (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            return this.methodMembers.get(renamedSignature);
        }
        assert (renamedSignature.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        return this.fieldMembers.get(renamedSignature);
    }

    @Override
    public MemberNaming lookupByOriginalSignature(MemberNaming.Signature original) {
        if (original.kind() == MemberNaming.Signature.SignatureKind.METHOD) {
            for (MemberNaming memberNaming : this.methodMembers.values()) {
                if (!memberNaming.signature.equals(original)) continue;
                return memberNaming;
            }
            return null;
        }
        assert (original.kind() == MemberNaming.Signature.SignatureKind.FIELD);
        for (MemberNaming memberNaming : this.fieldMembers.values()) {
            if (!memberNaming.signature.equals(original)) continue;
            return memberNaming;
        }
        return null;
    }

    public List<MemberNaming> lookupByOriginalName(String originalName) {
        ArrayList<MemberNaming> result = new ArrayList<MemberNaming>();
        for (MemberNaming naming : this.methodMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        for (MemberNaming naming : this.fieldMembers.values()) {
            if (!naming.signature.name.equals(originalName)) continue;
            result.add(naming);
        }
        return result;
    }

    @Override
    public <T extends Throwable> void forAllMemberNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        this.forAllFieldNaming(consumer);
        this.forAllMethodNaming(consumer);
    }

    @Override
    public <T extends Throwable> void forAllFieldNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.fieldMembers.values()) {
            consumer.accept(naming);
        }
    }

    @Override
    public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
        for (MemberNaming naming : this.methodMembers.values()) {
            consumer.accept(naming);
        }
    }

    void write(Writer writer, boolean collapseRanges) throws IOException {
        writer.append(this.originalName);
        writer.append(" -> ");
        writer.append(this.renamedName);
        writer.append(":\n");
        this.forAllMemberNaming(memberNaming -> memberNaming.write(writer, collapseRanges, true));
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer, false);
            return writer.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNamingForNameMapper)) {
            return false;
        }
        ClassNamingForNameMapper that = (ClassNamingForNameMapper)o;
        return this.originalName.equals(that.originalName) && this.renamedName.equals(that.renamedName) && this.methodMembers.equals(that.methodMembers) && this.fieldMembers.equals(that.fieldMembers);
    }

    public int hashCode() {
        int result = this.originalName.hashCode();
        result = 31 * result + this.renamedName.hashCode();
        result = 31 * result + this.methodMembers.hashCode();
        result = 31 * result + this.fieldMembers.hashCode();
        return result;
    }

    public static class Builder
    extends ClassNaming.Builder {
        private final String originalName;
        private final String renamedName;
        private final Map<MemberNaming.MethodSignature, MemberNaming> methodMembers = new HashMap<MemberNaming.MethodSignature, MemberNaming>();
        private final Map<MemberNaming.FieldSignature, MemberNaming> fieldMembers = new HashMap<MemberNaming.FieldSignature, MemberNaming>();

        private Builder(String renamedName, String originalName) {
            this.originalName = originalName;
            this.renamedName = renamedName;
        }

        @Override
        ClassNaming.Builder addMemberEntry(MemberNaming entry) {
            if (entry.isMethodNaming()) {
                this.methodMembers.put((MemberNaming.MethodSignature)entry.getRenamedSignature(), entry);
            } else {
                this.fieldMembers.put((MemberNaming.FieldSignature)entry.getRenamedSignature(), entry);
            }
            return this;
        }

        @Override
        ClassNamingForNameMapper build() {
            return new ClassNamingForNameMapper(this.renamedName, this.originalName, this.methodMembers, this.fieldMembers);
        }
    }
}

