/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing.r8;

import com.android.builder.dexing.r8.CachingArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.utils.DirectoryClassFileProvider;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ClassFileProviderFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong nextId = new AtomicLong();
    private static final WeakHashMap<Long, ClassFileProviderFactory> liveInstances = new WeakHashMap();
    private final long id;
    final transient Map<Path, ClassFileResourceProvider> providers = new WeakHashMap<Path, ClassFileResourceProvider>();
    private transient int openedHandlers = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFileProviderFactory() {
        WeakHashMap<Long, ClassFileProviderFactory> weakHashMap = liveInstances;
        synchronized (weakHashMap) {
            this.id = nextId.addAndGet(1L);
            liveInstances.put(this.id, this);
        }
    }

    private static ClassFileResourceProvider createProvider(Path entry) throws IOException {
        if (Files.isRegularFile(entry, new LinkOption[0])) {
            return new CachingArchiveClassFileProvider(entry);
        }
        if (Files.isDirectory(entry, new LinkOption[0])) {
            return DirectoryClassFileProvider.fromDirectory(entry);
        }
        throw new FileNotFoundException(entry.toString());
    }

    public synchronized Handler open() {
        ++this.openedHandlers;
        return new Handler();
    }

    private synchronized void handlerClosed() throws IOException {
        --this.openedHandlers;
        if (this.openedHandlers == 0) {
            for (ClassFileResourceProvider provider : this.providers.values()) {
                if (!(provider instanceof Closeable)) continue;
                ((Closeable)((Object)provider)).close();
            }
            this.providers.clear();
        }
    }

    private synchronized ClassFileResourceProvider getProvider(Path path) throws IOException {
        ClassFileResourceProvider provider = this.providers.get(path);
        if (provider == null) {
            provider = ClassFileProviderFactory.createProvider(path);
            this.providers.put(path, provider);
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() throws ObjectStreamException {
        Long key = this.id;
        WeakHashMap<Long, ClassFileProviderFactory> weakHashMap = liveInstances;
        synchronized (weakHashMap) {
            ClassFileProviderFactory existing = liveInstances.get(key);
            if (existing != null) {
                return existing;
            }
            liveInstances.put(key, this);
            return this;
        }
    }

    public class Handler
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private Handler() {
        }

        public ClassFileResourceProvider getProvider(Path path) throws IOException {
            return ClassFileProviderFactory.this.getProvider(path);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                ClassFileProviderFactory.this.handlerClosed();
            }
        }
    }
}

