/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.origin.Origin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;

public class ProgramResource
implements Resource {
    private final Kind kind;
    private final Resource resource;
    private final Set<String> classDescriptors;

    public static ProgramResource fromFile(Kind kind, Path file) {
        return new ProgramResource(kind, Resource.fromFile(file), null);
    }

    public static ProgramResource fromBytes(Kind kind, Origin origin, byte[] bytes, Set<String> typeDescriptors) {
        return new ProgramResource(kind, Resource.fromBytes(origin, bytes), typeDescriptors);
    }

    public ProgramResource(Kind kind, Resource resource, Set<String> classDescriptors) {
        assert (!(resource instanceof ProgramResource));
        this.kind = kind;
        this.resource = resource;
        this.classDescriptors = classDescriptors;
    }

    @Deprecated
    public ProgramResource(Kind kind, Resource resource) {
        this(kind, resource, resource.getClassDescriptors());
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public Origin getOrigin() {
        return this.resource.getOrigin();
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.resource.getStream();
    }

    @Override
    public Set<String> getClassDescriptors() {
        return this.classDescriptors;
    }

    public static enum Kind {
        CF,
        DEX;

    }
}

