/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Set;

public interface Resource {
    public static Resource fromFile(Path file) {
        return new FileResource(file);
    }

    public static Resource fromBytes(Origin origin, byte[] bytes) {
        return new ByteResource(origin, bytes);
    }

    @Deprecated
    public static Resource fromBytes(Origin origin, byte[] bytes, Set<String> typeDescriptors) {
        return new ByteResource(origin, bytes, typeDescriptors);
    }

    public Origin getOrigin();

    public InputStream getStream() throws IOException;

    @Deprecated
    public Set<String> getClassDescriptors();

    public static class ByteResource
    implements Resource {
        final Origin origin;
        final byte[] bytes;
        final Set<String> classDescriptors;

        ByteResource(Origin origin, byte[] bytes) {
            assert (bytes != null);
            this.origin = origin;
            this.bytes = bytes;
            this.classDescriptors = null;
        }

        @Deprecated
        ByteResource(Origin origin, byte[] bytes, Set<String> classDescriptors) {
            assert (bytes != null);
            this.origin = origin;
            this.bytes = bytes;
            this.classDescriptors = classDescriptors;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        @Deprecated
        public Set<String> getClassDescriptors() {
            return this.classDescriptors;
        }
    }

    public static class FileResource
    implements Resource {
        final Origin origin;
        final Path file;

        FileResource(Path file) {
            assert (file != null);
            this.origin = new PathOrigin(file);
            this.file = file;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file.toFile());
        }

        @Override
        @Deprecated
        public Set<String> getClassDescriptors() {
            return null;
        }
    }
}

