/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.Format11x;
import com.android.tools.r8.code.MoveResult;
import com.android.tools.r8.code.MoveResultObject;
import com.android.tools.r8.code.MoveResultWide;
import com.android.tools.r8.code.MoveType;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeSuper;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.List;

public abstract class Invoke
extends Instruction {
    public Invoke(Value result, List<Value> arguments) {
        super(result, arguments);
    }

    public static Invoke create(Type type, DexItem target, DexProto proto, Value result, List<Value> arguments) {
        switch (type) {
            case DIRECT: {
                return new InvokeDirect((DexMethod)target, result, arguments);
            }
            case INTERFACE: {
                return new InvokeInterface((DexMethod)target, result, arguments);
            }
            case STATIC: {
                return new InvokeStatic((DexMethod)target, result, arguments);
            }
            case SUPER: {
                return new InvokeSuper((DexMethod)target, result, arguments);
            }
            case VIRTUAL: {
                return new InvokeVirtual((DexMethod)target, result, arguments);
            }
            case NEW_ARRAY: {
                return new InvokeNewArray((DexType)target, result, arguments);
            }
            case CUSTOM: {
                throw new Unreachable("Use InvokeCustom constructor instead");
            }
            case POLYMORPHIC: {
                return new InvokePolymorphic((DexMethod)target, proto, result, arguments);
            }
        }
        throw new Unreachable("Unknown invoke type: " + (Object)((Object)type));
    }

    public static Instruction createFromTemplate(Invoke template, Value outValue, List<Value> inValues) {
        if (template.isInvokeMethod()) {
            return Invoke.create(template.getType(), template.asInvokeMethod().getInvokedMethod(), template.isInvokePolymorphic() ? template.asInvokePolymorphic().getProto() : null, outValue, inValues);
        }
        if (template.isInvokeNewArray()) {
            return new InvokeNewArray(template.asInvokeNewArray().getArrayType(), outValue, inValues);
        }
        assert (template.isInvokeCustom());
        InvokeCustom custom = template.asInvokeCustom();
        return new InvokeCustom(custom.getCallSite(), outValue, inValues);
    }

    public abstract Type getType();

    public abstract DexType getReturnType();

    public List<Value> arguments() {
        return this.inValues;
    }

    public int requiredArgumentRegisters() {
        int registers = 0;
        for (Value inValue : this.inValues) {
            registers += inValue.requiredRegisters();
        }
        return registers;
    }

    protected int argumentRegisterValue(int i, DexBuilder builder) {
        assert (this.needsRangedInvoke(builder));
        if (i < this.arguments().size()) {
            return builder.argumentOrAllocateRegister(this.arguments().get(i), this.getNumber());
        }
        return 0;
    }

    protected int fillArgumentRegisters(DexBuilder builder, int[] registers) {
        int i = 0;
        for (Value value : this.arguments()) {
            int register = builder.allocatedRegister(value, this.getNumber());
            for (int j = 0; j < value.requiredRegisters(); ++j) {
                assert (i < 5);
                registers[i++] = register++;
            }
        }
        return i;
    }

    protected boolean hasHighArgumentRegister(DexBuilder builder) {
        for (Value value : this.arguments()) {
            if (!builder.argumentValueUsesHighRegister(value, this.getNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean argumentsConsecutive(DexBuilder builder) {
        Value value = this.arguments().get(0);
        int next = builder.argumentOrAllocateRegister(value, this.getNumber()) + value.requiredRegisters();
        for (int i = 1; i < this.arguments().size(); ++i) {
            value = this.arguments().get(i);
            assert (next == builder.argumentOrAllocateRegister(value, this.getNumber()));
            next += value.requiredRegisters();
        }
        return true;
    }

    protected void addInvokeAndMoveResult(com.android.tools.r8.code.Instruction instruction, DexBuilder builder) {
        if (this.outValue != null && this.outValue.needsRegister()) {
            Format11x moveResult;
            MoveType moveType = MoveType.fromValueType(this.outType());
            int register = builder.allocatedRegister(this.outValue, this.getNumber());
            switch (moveType) {
                case SINGLE: {
                    moveResult = new MoveResult(register);
                    break;
                }
                case WIDE: {
                    moveResult = new MoveResultWide(register);
                    break;
                }
                case OBJECT: {
                    moveResult = new MoveResultObject(register);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected result type " + (Object)((Object)this.outType()));
                }
            }
            builder.add((Instruction)this, new com.android.tools.r8.code.Instruction[]{instruction, moveResult});
        } else {
            builder.add((Instruction)this, instruction);
        }
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public int maxInValueRegister() {
        if (this.requiredArgumentRegisters() > 5) {
            return 65535;
        }
        if (this.argumentsAreConsecutiveInputArguments()) {
            return 65535;
        }
        return 15;
    }

    private boolean argumentsAreConsecutiveInputArguments() {
        if (this.arguments().size() == 0) {
            return false;
        }
        Value current = this.arguments().get(0);
        if (!current.isArgument()) {
            return false;
        }
        for (int i = 1; i < this.arguments().size(); ++i) {
            Value next = this.arguments().get(i);
            if (current.getNextConsecutive() != next) {
                return false;
            }
            current = next;
        }
        return true;
    }

    private boolean argumentsAreConsecutiveInputArgumentsWithHighRegisters(DexBuilder builder) {
        if (!this.argumentsAreConsecutiveInputArguments()) {
            return false;
        }
        Value lastArgument = this.arguments().get(this.arguments().size() - 1);
        return builder.argumentOrAllocateRegister(lastArgument, this.getNumber()) > 15;
    }

    protected boolean needsRangedInvoke(DexBuilder builder) {
        return this.requiredArgumentRegisters() > 5 || this.hasHighArgumentRegister(builder) || this.argumentsAreConsecutiveInputArgumentsWithHighRegisters(builder);
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    protected abstract String getTypeString();

    @Override
    public String getInstructionName() {
        return "Invoke-" + this.getTypeString();
    }

    public abstract DexEncodedMethod computeSingleTarget(AppInfoWithSubtyping var1);

    @Override
    public boolean isInvoke() {
        return true;
    }

    @Override
    public Invoke asInvoke() {
        return this;
    }

    public static enum Type {
        DIRECT,
        INTERFACE,
        STATIC,
        SUPER,
        VIRTUAL,
        NEW_ARRAY,
        CUSTOM,
        POLYMORPHIC;

    }
}

