/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugEventVisitor;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugPositionState;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;

public class LineNumberOptimizer {
    public static ClassNameMapper run(DexApplication application, NamingLens namingLens, boolean identityMapping) {
        IdentityHashMap classesOfFiles = new IdentityHashMap();
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        for (DexProgramClass clazz : application.classes()) {
            if (!clazz.getSynthesizedFrom().isEmpty()) continue;
            IdentityHashMap methodsByName = new IdentityHashMap(clazz.directMethods().length + clazz.virtualMethods().length);
            clazz.forEachMethod(method -> {
                if (LineNumberOptimizer.doesContainPositions(method)) {
                    methodsByName.compute(method.method.name, (name, methods) -> {
                        if (methods == null) {
                            methods = new ArrayList<DexEncodedMethod>();
                        }
                        methods.add(method);
                        return methods;
                    });
                }
            });
            ClassNamingForNameMapper.Builder classNamingBuilder = classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor(clazz.getType()).toString()), clazz.toString());
            clazz.forEachField(dexEncodedField -> {
                DexField dexField = dexEncodedField.field;
                DexString renamedName = namingLens.lookupName(dexField);
                if (!renamedName.equals(dexField.name)) {
                    MemberNaming.FieldSignature signature = new MemberNaming.FieldSignature(dexField.name.toString(), dexField.type.toString());
                    MemberNaming memberNaming = new MemberNaming(signature, renamedName.toString());
                    classNamingBuilder.addMemberEntry(memberNaming);
                }
            });
            for (List methods : methodsByName.values()) {
                if (methods.size() > 1) {
                    methods.sort((lhs, rhs) -> {
                        int startLineDiff = lhs.getCode().asDexCode().getDebugInfo().startLine - rhs.getCode().asDexCode().getDebugInfo().startLine;
                        if (startLineDiff != 0) {
                            return startLineDiff;
                        }
                        return DexEncodedMethod.slowCompare(lhs, rhs);
                    });
                }
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper();
                for (DexEncodedMethod method2 : methods) {
                    class MappedPosition {
                        private final DexMethod method;
                        private final int originalLine;
                        private final Position caller;
                        private final int targetLine;

                        MappedPosition(DexMethod method, int originalLine, Position caller, int targetline) {
                            this.method = method;
                            this.originalLine = originalLine;
                            this.caller = caller;
                            this.targetLine = targetline;
                        }
                    }
                    DexCode dexCode = method2.getCode().asDexCode();
                    DexDebugInfo debugInfo = dexCode.getDebugInfo();
                    ArrayList processedEvents = new ArrayList();
                    PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, method2.method, processedEvents);
                    ArrayList mappedPositions = new ArrayList();
                    EventFilter eventFilter = new EventFilter(debugInfo.startLine, method2.method, processedEvents::add, positionState -> {
                        Position position = positionRemapper.createRemappedPosition(positionState);
                        mappedPositions.add(new MappedPosition(positionState.getCurrentMethod(), positionState.getCurrentLine(), positionState.getCurrentCallerPosition(), position.line));
                        positionEventEmitter.emitPositionEvents(positionState.getCurrentPc(), position);
                    });
                    for (DexDebugEvent event : debugInfo.events) {
                        event.accept(eventFilter);
                    }
                    DexDebugInfo optimizedDebugInfo = new DexDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(new DexDebugEvent[processedEvents.size()]));
                    if (identityMapping) {
                        assert (optimizedDebugInfo.startLine == debugInfo.startLine);
                        assert (optimizedDebugInfo.events.length == debugInfo.events.length);
                        for (int i = 0; i < debugInfo.events.length; ++i) {
                            assert (optimizedDebugInfo.events[i].equals(debugInfo.events[i]));
                        }
                    }
                    dexCode.setDebugInfo(optimizedDebugInfo);
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(method2.method);
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(method2.method, originalSignature);
                    String obfuscatedName = namingLens.lookupName(method2.method).toString();
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)classNamingBuilder).addMemberEntry(memberNaming);
                    if (mappedPositions.isEmpty()) {
                        ((ClassNaming.Builder)classNamingBuilder).addMappedRange(null, originalSignature, null, obfuscatedName);
                    }
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size(); ++j) {
                            MappedPosition mp = (MappedPosition)mappedPositions.get(j);
                            assert (mp.caller == lastPosition.caller == Objects.equals(mp.caller, lastPosition.caller));
                            if (mp.caller != lastPosition.caller || mp.method != lastPosition.method || mp.originalLine - lastPosition.originalLine != mp.targetLine - lastPosition.targetLine) break;
                            lastPosition = mp;
                        }
                        Range targetRange = new Range(firstPosition.targetLine, lastPosition.targetLine);
                        Range originalRange = new Range(firstPosition.originalLine, lastPosition.originalLine);
                        ((ClassNaming.Builder)classNamingBuilder).addMappedRange(targetRange, signatures.computeIfAbsent(firstPosition.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, ((MappedPosition)firstPosition).method.holder != clazz.getType())), originalRange, obfuscatedName);
                        Position caller = firstPosition.caller;
                        while (caller != null) {
                            Position finalCaller = caller;
                            ((ClassNaming.Builder)classNamingBuilder).addMappedRange(targetRange, signatures.computeIfAbsent(caller.method, m -> MemberNaming.MethodSignature.fromDexMethod(m, finalCaller.method.holder != clazz.getType())), caller.line, obfuscatedName);
                            caller = caller.callerPosition;
                        }
                        i = j;
                    }
                }
            }
        }
        return classNameMapperBuilder.build();
    }

    private static boolean checkMethodsForSelfReferenceInPositions(DexEncodedMethod[] methods) {
        for (DexEncodedMethod method : methods) {
            if (!LineNumberOptimizer.doesContainPositions(method)) continue;
            DexDebugInfo debugInfo = method.getCode().asDexCode().getDebugInfo();
            DexDebugPositionState positionState = new DexDebugPositionState(debugInfo.startLine, method.method);
            for (DexDebugEvent event : debugInfo.events) {
                DexMethod outermostMethod;
                event.accept(positionState);
                if (!(event instanceof DexDebugEvent.Default)) continue;
                Position caller = positionState.getCurrentCallerPosition();
                DexMethod dexMethod = outermostMethod = caller == null ? positionState.getCurrentMethod() : caller.getOutermostCaller().method;
                if (outermostMethod != method.method) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null || !code.isDexCode()) {
            return false;
        }
        DexDebugInfo debugInfo = code.asDexCode().getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        for (DexDebugEvent event : debugInfo.events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private DexMethod method;
        private int previousPc = -1;
        private Position previousPosition = null;
        private List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.line;
                this.previousPosition = new Position(this.startLine, null, this.method, null);
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private int nextLineNumber = 1;

        private OptimizingPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(DexDebugPositionState positionState) {
            Position newPosition = new Position(this.nextLineNumber, positionState.getCurrentFile(), positionState.getCurrentMethod(), null);
            ++this.nextLineNumber;
            return newPosition;
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Position createRemappedPosition(DexDebugPositionState positionState) {
            return new Position(positionState.getCurrentLine(), positionState.getCurrentFile(), positionState.getCurrentMethod(), positionState.getCurrentCallerPosition());
        }
    }

    private static interface PositionRemapper {
        public Position createRemappedPosition(DexDebugPositionState var1);
    }

    private static class EventFilter
    implements DexDebugEventVisitor {
        private final BypassedEventReceiver bypassedEventReceiver;
        private final PositionEventReceiver positionEventReceiver;
        private DexDebugPositionState positionState;

        private EventFilter(int startLine, DexMethod method, BypassedEventReceiver bypassedEventReceiver, PositionEventReceiver positionEventReceiver) {
            this.positionState = new DexDebugPositionState(startLine, method);
            this.bypassedEventReceiver = bypassedEventReceiver;
            this.positionEventReceiver = positionEventReceiver;
        }

        @Override
        public void visit(DexDebugEvent.SetPrologueEnd event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.SetEpilogueBegin event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.StartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.EndLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.RestartLocal event) {
            this.bypassedEventReceiver.receiveBypassedEvent(event);
        }

        @Override
        public void visit(DexDebugEvent.AdvancePC advancePC) {
            this.positionState.visit(advancePC);
        }

        @Override
        public void visit(DexDebugEvent.AdvanceLine advanceLine) {
            this.positionState.visit(advanceLine);
        }

        @Override
        public void visit(DexDebugEvent.SetInlineFrame setInlineFrame) {
            this.positionState.visit(setInlineFrame);
        }

        @Override
        public void visit(DexDebugEvent.Default defaultEvent) {
            this.positionState.visit(defaultEvent);
            this.positionEventReceiver.receivePositionEvent(this.positionState);
        }

        @Override
        public void visit(DexDebugEvent.SetFile setFile) {
            this.positionState.visit(setFile);
        }

        private static interface PositionEventReceiver {
            public void receivePositionEvent(DexDebugPositionState var1);
        }

        private static interface BypassedEventReceiver {
            public void receiveBypassedEvent(DexDebugEvent var1);
        }
    }
}

