/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.InternalOptions;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadUtils {
    public static final int NOT_SPECIFIED = -1;

    public static void awaitFutures(Iterable<? extends Future<?>> futures) throws ExecutionException {
        Iterator<Future<?>> it = futures.iterator();
        try {
            while (it.hasNext()) {
                it.next().get();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for future.", e);
        }
        finally {
            while (it.hasNext()) {
                try {
                    it.next().get();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static ExecutorService getExecutorService(int threads) {
        if (threads == -1) {
            threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
        }
        return Executors.newWorkStealingPool(threads);
    }

    public static ExecutorService getExecutorService(InternalOptions options) {
        return ThreadUtils.getExecutorService(options.numberOfThreads);
    }
}

