/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.android.builder.desugaring.DesugaringData;
import com.android.builder.desugaring.TypeDependencies;
import com.android.builder.desugaring.TypePaths;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DesugaringGraph {
    private final TypeDependencies typeDependencies = new TypeDependencies();
    private final TypePaths typePaths = new TypePaths();

    DesugaringGraph(Collection<DesugaringData> data) {
        for (DesugaringData d : data) {
            this.typeDependencies.add(d.getInternalName(), d.getDependencies());
            this.typePaths.add(d.getPath(), d.getInternalName());
        }
    }

    public void update(Collection<DesugaringData> data) {
        this.removeItems(data);
        this.insertLiveItems(data);
    }

    public Set<Path> getDependentPaths(Path path) {
        Set<String> types = this.typePaths.getTypes(path);
        HashSet impactedTypes = Sets.newHashSet();
        for (String type : types) {
            impactedTypes.addAll(this.typeDependencies.getAllDependents(type));
        }
        HashSet impactedPaths = Sets.newHashSetWithExpectedSize((int)impactedTypes.size());
        for (String impactedType : impactedTypes) {
            impactedPaths.addAll(this.typePaths.getPaths(impactedType));
        }
        impactedPaths.remove(path);
        return impactedPaths;
    }

    Set<String> getDependents(String type) {
        return this.typeDependencies.getDependents(type);
    }

    Set<String> getDependencies(String type) {
        return this.typeDependencies.getDependencies(type);
    }

    Set<String> getAllDependentTypes(String type) {
        return this.typeDependencies.getAllDependents(type);
    }

    private void removeItems(Collection<DesugaringData> data) {
        Set<Path> modifiedPaths = data.stream().map(DesugaringData::getPath).collect(Collectors.toSet());
        for (DesugaringData d : data) {
            Set<String> typesInPath = this.typePaths.remove(d.getPath(), modifiedPaths);
            if (typesInPath == null) continue;
            for (String removedType : typesInPath) {
                this.typeDependencies.remove(removedType);
            }
        }
    }

    private void insertLiveItems(Collection<DesugaringData> data) {
        for (DesugaringData d : data) {
            if (!d.isLive()) continue;
            this.typePaths.add(d.getPath(), d.getInternalName());
            this.typeDependencies.add(d.getInternalName(), d.getDependencies());
        }
    }
}

