/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

public interface Utf8Consumer {
    public void accept(byte[] var1, DiagnosticsHandler var2);

    public static EmptyConsumer emptyConsumer() {
        return EmptyConsumer.EMPTY_CONSUMER;
    }

    public static class StreamConsumer
    extends ForwardingConsumer {
        private final Origin origin;
        private final OutputStream outputStream;

        public StreamConsumer(Origin origin, OutputStream outputStream) {
            this(origin, outputStream, null);
        }

        public StreamConsumer(Origin origin, OutputStream outputStream, Utf8Consumer consumer) {
            super(consumer);
            this.origin = origin;
            this.outputStream = outputStream;
        }

        @Override
        public void accept(byte[] data, DiagnosticsHandler handler) {
            super.accept(data, handler);
            try {
                this.outputStream.write(data);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }
    }

    public static class FileConsumer
    extends ForwardingConsumer {
        private final Path outputPath;

        public FileConsumer(Path outputPath) {
            this(outputPath, null);
        }

        public FileConsumer(Path outputPath, Utf8Consumer consumer) {
            super(consumer);
            this.outputPath = outputPath;
        }

        @Override
        public void accept(byte[] data, DiagnosticsHandler handler) {
            super.accept(data, handler);
            try {
                FileUtils.writeToFile(this.outputPath, null, data);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(this.outputPath)));
            }
        }
    }

    public static class ForwardingConsumer
    implements Utf8Consumer {
        private final Utf8Consumer consumer;

        public ForwardingConsumer(Utf8Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(byte[] data, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(data, handler);
            }
        }
    }

    public static class EmptyConsumer
    implements Utf8Consumer {
        private static EmptyConsumer EMPTY_CONSUMER = new EmptyConsumer();

        @Override
        public void accept(byte[] data, DiagnosticsHandler handler) {
        }
    }
}

