/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.bisect;

import com.android.tools.r8.bisect.BisectOptions;
import com.android.tools.r8.bisect.BisectState;
import com.android.tools.r8.com.google.common.io.CharStreams;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AndroidAppConsumers;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.Timing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Bisect {
    private final BisectOptions options;
    private final Timing timing = new Timing("bisect");

    public Bisect(BisectOptions options) {
        this.options = options;
    }

    public static DexProgramClass run(BisectState state, Command command, Path output, ExecutorService executor) throws Exception {
        while (true) {
            DexApplication app = state.bisect();
            state.write();
            if (app == null) {
                return state.getFinalClass();
            }
            if (command == null) {
                Bisect.writeApp(app, output, executor);
                System.out.println("Bisecting completed with build in " + output + "/");
                System.out.println("Continue bisection by passing either --result-good or --result-bad");
                return null;
            }
            state.setPreviousResult(command.apply(app));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexProgramClass run() throws Exception {
        Path output;
        if (this.options.output != null) {
            output = this.options.output.toPath();
        } else {
            File temp = File.createTempFile("bisect", "", new File("/tmp"));
            temp.delete();
            temp.mkdir();
            output = temp.toPath();
        }
        ExecutorService executor = Executors.newWorkStealingPool();
        try {
            DexApplication goodApp = this.readApp(this.options.goodBuild, executor);
            DexApplication badApp = this.readApp(this.options.badBuild, executor);
            File stateFile = this.options.stateFile != null ? this.options.stateFile : output.resolve("bisect.state").toFile();
            BisectState state = new BisectState(goodApp, badApp, stateFile);
            if (this.options.stateFile != null) {
                state.read();
            }
            if (this.options.result != BisectOptions.Result.UNKNOWN) {
                state.setPreviousResult(this.options.result);
            }
            Command command = null;
            if (this.options.command != null) {
                command = application -> {
                    Bisect.writeApp(application, output, executor);
                    return this.runCommand(output);
                };
            }
            DexProgramClass dexProgramClass = Bisect.run(state, command, output, executor);
            return dexProgramClass;
        }
        finally {
            executor.shutdown();
        }
    }

    private BisectOptions.Result runCommand(Path output) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("/bin/bash");
        args.add(this.options.command.toString());
        args.add(output.toString());
        ProcessBuilder builder = new ProcessBuilder(args);
        Process process = builder.start();
        StreamReader stdoutReader = new StreamReader(process.getInputStream());
        StreamReader stderrReader = new StreamReader(process.getErrorStream());
        Thread stdoutThread = new Thread(stdoutReader);
        Thread stderrThread = new Thread(stderrReader);
        stdoutThread.start();
        stderrThread.start();
        try {
            process.waitFor();
            stdoutThread.join();
            stderrThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Execution interrupted", e);
        }
        int result = process.exitValue();
        if (result == 0) {
            return BisectOptions.Result.GOOD;
        }
        if (result == 1) {
            return BisectOptions.Result.BAD;
        }
        System.out.println("Failed to run command " + args);
        System.out.println("Exit code: " + result + " (expected 0 for good, 1 for bad)");
        System.out.println("Std out:\n" + stdoutReader.getResult());
        System.out.println("Std err:\n" + stderrReader.getResult());
        throw new CompilationError("Failed to run command " + args);
    }

    private DexApplication readApp(File apk, ExecutorService executor) throws IOException, ExecutionException {
        AndroidApp app = AndroidApp.fromProgramFiles(apk.toPath());
        return new ApplicationReader(app, new InternalOptions(), this.timing).read(executor);
    }

    private static void writeApp(DexApplication app, Path output, ExecutorService executor) throws IOException, ExecutionException, DexOverflowException {
        InternalOptions options = new InternalOptions();
        AndroidAppConsumers compatSink = new AndroidAppConsumers(options);
        ApplicationWriter writer = new ApplicationWriter(app, options, null, null, null, null, null);
        writer.write(executor);
        compatSink.build().writeToDirectory(output, OutputMode.Indexed);
    }

    public static void main(String[] args) throws Exception {
        BisectOptions options = null;
        try {
            options = BisectOptions.parse(args);
        }
        catch (CompilationError e) {
            System.err.println(e.getMessage());
            BisectOptions.printHelp(System.err);
            return;
        }
        if (options == null) {
            return;
        }
        DexProgramClass clazz = new Bisect(options).run();
        if (clazz != null) {
            System.out.println("Bisection found final bad class " + clazz);
        }
    }

    private static class StreamReader
    implements Runnable {
        private InputStream stream;
        private String result;

        public StreamReader(InputStream stream) {
            this.stream = stream;
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = CharStreams.toString(new InputStreamReader(this.stream, StandardCharsets.UTF_8));
                this.stream.close();
            }
            catch (IOException e) {
                this.result = "Failed reading result for stream " + this.stream;
            }
        }
    }

    public static interface Command {
        public BisectOptions.Result apply(DexApplication var1) throws Exception;
    }
}

